package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IntegrationPlatformBuildSpecFluent<A extends IntegrationPlatformBuildSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(int[] arg1,int arg2,int arg3);
    public A withNewBaseImage(char[] arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A withNewBaseImage(byte[] arg1,int arg2);
    public A withNewBaseImage(byte[] arg1);
    public A withNewBaseImage(char[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBaseImage(String arg1);
    public String getBuildStrategy();
    public A withBuildStrategy(String buildStrategy);
    public Boolean hasBuildStrategy();
    public A withNewBuildStrategy(StringBuilder arg1);
    public A withNewBuildStrategy(int[] arg1,int arg2,int arg3);
    public A withNewBuildStrategy(char[] arg1);
    public A withNewBuildStrategy(StringBuffer arg1);
    public A withNewBuildStrategy(byte[] arg1,int arg2);
    public A withNewBuildStrategy(byte[] arg1);
    public A withNewBuildStrategy(char[] arg1,int arg2,int arg3);
    public A withNewBuildStrategy(byte[] arg1,int arg2,int arg3);
    public A withNewBuildStrategy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBuildStrategy(String arg1);
    public String getHttpProxySecret();
    public A withHttpProxySecret(String httpProxySecret);
    public Boolean hasHttpProxySecret();
    public A withNewHttpProxySecret(StringBuilder arg1);
    public A withNewHttpProxySecret(int[] arg1,int arg2,int arg3);
    public A withNewHttpProxySecret(char[] arg1);
    public A withNewHttpProxySecret(StringBuffer arg1);
    public A withNewHttpProxySecret(byte[] arg1,int arg2);
    public A withNewHttpProxySecret(byte[] arg1);
    public A withNewHttpProxySecret(char[] arg1,int arg2,int arg3);
    public A withNewHttpProxySecret(byte[] arg1,int arg2,int arg3);
    public A withNewHttpProxySecret(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHttpProxySecret(String arg1);
    public Boolean getKanikoBuildCache();
    public A withKanikoBuildCache(Boolean kanikoBuildCache);
    public Boolean hasKanikoBuildCache();
    public A withNewKanikoBuildCache(String arg1);
    public A withNewKanikoBuildCache(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildMaven instead.
 * @return The buildable object.
 */
@Deprecated public MavenSpec getMaven();
    public MavenSpec buildMaven();
    public A withMaven(MavenSpec maven);
    public Boolean hasMaven();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMaven();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> withNewMavenLike(MavenSpec item);
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editMaven();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMaven();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item);
    public String getPersistentVolumeClaim();
    public A withPersistentVolumeClaim(String persistentVolumeClaim);
    public Boolean hasPersistentVolumeClaim();
    public A withNewPersistentVolumeClaim(StringBuilder arg1);
    public A withNewPersistentVolumeClaim(int[] arg1,int arg2,int arg3);
    public A withNewPersistentVolumeClaim(char[] arg1);
    public A withNewPersistentVolumeClaim(StringBuffer arg1);
    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2);
    public A withNewPersistentVolumeClaim(byte[] arg1);
    public A withNewPersistentVolumeClaim(char[] arg1,int arg2,int arg3);
    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2,int arg3);
    public A withNewPersistentVolumeClaim(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPersistentVolumeClaim(String arg1);
    public A addToProperties(String key,String value);
    public A addToProperties(java.util.Map<String,String> map);
    public A removeFromProperties(String key);
    public A removeFromProperties(java.util.Map<String,String> map);
    public java.util.Map<String,String> getProperties();
    public <K extends Object,V extends Object>A withProperties(java.util.Map<String,String> properties);
    public Boolean hasProperties();
    public String getPublishStrategy();
    public A withPublishStrategy(String publishStrategy);
    public Boolean hasPublishStrategy();
    public A withNewPublishStrategy(StringBuilder arg1);
    public A withNewPublishStrategy(int[] arg1,int arg2,int arg3);
    public A withNewPublishStrategy(char[] arg1);
    public A withNewPublishStrategy(StringBuffer arg1);
    public A withNewPublishStrategy(byte[] arg1,int arg2);
    public A withNewPublishStrategy(byte[] arg1);
    public A withNewPublishStrategy(char[] arg1,int arg2,int arg3);
    public A withNewPublishStrategy(byte[] arg1,int arg2,int arg3);
    public A withNewPublishStrategy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPublishStrategy(String arg1);
    
/**
 * This method has been deprecated, please use method buildRegistry instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformRegistrySpec getRegistry();
    public IntegrationPlatformRegistrySpec buildRegistry();
    public A withRegistry(IntegrationPlatformRegistrySpec registry);
    public Boolean hasRegistry();
    public A withNewRegistry(String address,String ca,Boolean insecure,String organization,String secret);
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistry();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> withNewRegistryLike(IntegrationPlatformRegistrySpec item);
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editRegistry();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistry();
    public io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<A> editOrNewRegistryLike(IntegrationPlatformRegistrySpec item);
    public String getRuntimeProvider();
    public A withRuntimeProvider(String runtimeProvider);
    public Boolean hasRuntimeProvider();
    public A withNewRuntimeProvider(StringBuilder arg1);
    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(char[] arg1);
    public A withNewRuntimeProvider(StringBuffer arg1);
    public A withNewRuntimeProvider(byte[] arg1,int arg2);
    public A withNewRuntimeProvider(byte[] arg1);
    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeProvider(String arg1);
    public String getRuntimeVersion();
    public A withRuntimeVersion(String runtimeVersion);
    public Boolean hasRuntimeVersion();
    public A withNewRuntimeVersion(StringBuilder arg1);
    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(char[] arg1);
    public A withNewRuntimeVersion(StringBuffer arg1);
    public A withNewRuntimeVersion(byte[] arg1,int arg2);
    public A withNewRuntimeVersion(byte[] arg1);
    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeVersion(String arg1);
    public Duration getTimeout();
    public A withTimeout(Duration timeout);
    public Boolean hasTimeout();
    public interface MavenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MavenSpecFluent<io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.MavenNested<N>> {

            public N and();
            public N endMaven();    }


    public interface RegistryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationPlatformRegistrySpecFluent<io.fabric8.camelk.v1.IntegrationPlatformBuildSpecFluent.RegistryNested<N>> {

            public N and();
            public N endRegistry();    }


}
