package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class CamelCatalogSpecFluentImpl<A extends CamelCatalogSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CamelCatalogSpecFluent<A> {

    private java.util.Map<String,CamelArtifact> artifacts;
    private java.util.Map<String,CamelLoader> loaders;
    private RuntimeSpecBuilder runtime;

    public CamelCatalogSpecFluentImpl() {
    }

    public CamelCatalogSpecFluentImpl(CamelCatalogSpec instance) {
        this.withArtifacts(instance.getArtifacts()); 
        this.withLoaders(instance.getLoaders()); 
        this.withRuntime(instance.getRuntime()); 
    }

    public A addToArtifacts(String key,CamelArtifact value) {
        if(this.artifacts == null && key != null && value != null) { this.artifacts = new LinkedHashMap<String,CamelArtifact>(); }
        if(key != null && value != null) {this.artifacts.put(key, value);} return (A)this;
    }

    public A addToArtifacts(java.util.Map<String,CamelArtifact> map) {
        if(this.artifacts == null && map != null) { this.artifacts = new LinkedHashMap<String,CamelArtifact>(); }
        if(map != null) { this.artifacts.putAll(map);} return (A)this;
    }

    public A removeFromArtifacts(String key) {
        if(this.artifacts == null) { return (A) this; }
        if(key != null && this.artifacts != null) {this.artifacts.remove(key);} return (A)this;
    }

    public A removeFromArtifacts(java.util.Map<String,CamelArtifact> map) {
        if(this.artifacts == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.artifacts != null){this.artifacts.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,CamelArtifact> getArtifacts() {
        return this.artifacts;
    }

    public <K extends Object,V extends Object>A withArtifacts(java.util.Map<String,CamelArtifact> artifacts) {
        if (artifacts == null) { this.artifacts =  null;} else {this.artifacts = new LinkedHashMap<String,CamelArtifact>(artifacts);} return (A) this;
    }

    public Boolean hasArtifacts() {
        return this.artifacts != null;
    }

    public A addToLoaders(String key,CamelLoader value) {
        if(this.loaders == null && key != null && value != null) { this.loaders = new LinkedHashMap<String,CamelLoader>(); }
        if(key != null && value != null) {this.loaders.put(key, value);} return (A)this;
    }

    public A addToLoaders(java.util.Map<String,CamelLoader> map) {
        if(this.loaders == null && map != null) { this.loaders = new LinkedHashMap<String,CamelLoader>(); }
        if(map != null) { this.loaders.putAll(map);} return (A)this;
    }

    public A removeFromLoaders(String key) {
        if(this.loaders == null) { return (A) this; }
        if(key != null && this.loaders != null) {this.loaders.remove(key);} return (A)this;
    }

    public A removeFromLoaders(java.util.Map<String,CamelLoader> map) {
        if(this.loaders == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.loaders != null){this.loaders.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,CamelLoader> getLoaders() {
        return this.loaders;
    }

    public <K extends Object,V extends Object>A withLoaders(java.util.Map<String,CamelLoader> loaders) {
        if (loaders == null) { this.loaders =  null;} else {this.loaders = new LinkedHashMap<String,CamelLoader>(loaders);} return (A) this;
    }

    public Boolean hasLoaders() {
        return this.loaders != null;
    }

    
/**
 * This method has been deprecated, please use method buildRuntime instead.
 * @return The buildable object.
 */
@Deprecated public RuntimeSpec getRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public RuntimeSpec buildRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public A withRuntime(RuntimeSpec runtime) {
        _visitables.get("runtime").remove(this.runtime);
        if (runtime!=null){ this.runtime= new RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} return (A) this;
    }

    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    public io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntime() {
        return new RuntimeNestedImpl();
    }

    public io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
        return new RuntimeNestedImpl(item);
    }

    public io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<A> editRuntime() {
        return withNewRuntimeLike(getRuntime());
    }

    public io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntime() {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new RuntimeSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelCatalogSpecFluentImpl that = (CamelCatalogSpecFluentImpl) o;
        if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
        if (loaders != null ? !loaders.equals(that.loaders) :that.loaders != null) return false;
        if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifacts,  loaders,  runtime,  super.hashCode());
    }

    public class RuntimeNestedImpl<N> extends RuntimeSpecFluentImpl<io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<N>> implements io.fabric8.camelk.v1.CamelCatalogSpecFluent.RuntimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuntimeSpecBuilder builder;

            RuntimeNestedImpl(RuntimeSpec item) {
                this.builder = new RuntimeSpecBuilder(this, item);
                        
            }

            RuntimeNestedImpl() {
                this.builder = new RuntimeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) CamelCatalogSpecFluentImpl.this.withRuntime(builder.build());
            }

            public N endRuntime() {
                return and();
            }
    }


}
