package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<BuildSpec,BuildSpecBuilder> {

    BuildSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BuildSpecBuilder() {
        this(true);
    }

    public BuildSpecBuilder(Boolean validationEnabled) {
        this(new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance) {
        this(fluent, instance, true);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTasks(instance.getTasks()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildSpecBuilder(BuildSpec instance) {
        this(instance,true);
    }

    public BuildSpecBuilder(BuildSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTasks(instance.getTasks()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableBuildSpec build() {
        EditableBuildSpec buildable = new EditableBuildSpec(fluent.getTasks());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildSpecBuilder that = (BuildSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
