package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraitConfigurationBuilder extends TraitConfigurationFluentImpl<TraitConfigurationBuilder> implements VisitableBuilder<TraitConfiguration,TraitConfigurationBuilder> {

    TraitConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public TraitConfigurationBuilder() {
        this(true);
    }

    public TraitConfigurationBuilder(Boolean validationEnabled) {
        this(new TraitConfiguration(), validationEnabled);
    }

    public TraitConfigurationBuilder(TraitConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public TraitConfigurationBuilder(TraitConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TraitConfiguration(), validationEnabled);
    }

    public TraitConfigurationBuilder(TraitConfigurationFluent<?> fluent,TraitConfiguration instance) {
        this(fluent, instance, true);
    }

    public TraitConfigurationBuilder(TraitConfigurationFluent<?> fluent,TraitConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public TraitConfigurationBuilder(TraitConfiguration instance) {
        this(instance,true);
    }

    public TraitConfigurationBuilder(TraitConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableTraitConfiguration build() {
        EditableTraitConfiguration buildable = new EditableTraitConfiguration();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TraitConfigurationBuilder that = (TraitConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
