package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TaskBuilder extends TaskFluentImpl<TaskBuilder> implements VisitableBuilder<Task,TaskBuilder> {

    TaskFluent<?> fluent;
    Boolean validationEnabled;

    public TaskBuilder() {
        this(true);
    }

    public TaskBuilder(Boolean validationEnabled) {
        this(new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent) {
        this(fluent, true);
    }

    public TaskBuilder(TaskFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent,Task instance) {
        this(fluent, instance, true);
    }

    public TaskBuilder(TaskFluent<?> fluent,Task instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuilder(instance.getBuilder()); 
        fluent.withImage(instance.getImage()); 
        this.validationEnabled = validationEnabled; 
    }

    public TaskBuilder(Task instance) {
        this(instance,true);
    }

    public TaskBuilder(Task instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuilder(instance.getBuilder()); 
        this.withImage(instance.getImage()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableTask build() {
        EditableTask buildable = new EditableTask(fluent.getBuilder(),fluent.getImage());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TaskBuilder that = (TaskBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
