package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface IntegrationStatusFluent<A extends IntegrationStatusFluent<A>> extends Fluent<A> {


    public A addToCapabilities(int index,String item);
    public A setToCapabilities(int index,String item);
    public A addToCapabilities(String... items);
    public A addAllToCapabilities(Collection<String> items);
    public A removeFromCapabilities(String... items);
    public A removeAllFromCapabilities(Collection<String> items);
    public List<String> getCapabilities();
    public String getCapability(int index);
    public String getFirstCapability();
    public String getLastCapability();
    public String getMatchingCapability(Predicate<String> predicate);
    public Boolean hasMatchingCapability(Predicate<String> predicate);
    public A withCapabilities(List<String> capabilities);
    public A withCapabilities(String... capabilities);
    public Boolean hasCapabilities();
    public A addNewCapability(StringBuilder arg1);
    public A addNewCapability(int[] arg1,int arg2,int arg3);
    public A addNewCapability(char[] arg1);
    public A addNewCapability(StringBuffer arg1);
    public A addNewCapability(byte[] arg1,int arg2);
    public A addNewCapability(byte[] arg1);
    public A addNewCapability(char[] arg1,int arg2,int arg3);
    public A addNewCapability(byte[] arg1,int arg2,int arg3);
    public A addNewCapability(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewCapability(String arg1);
    public A addToConditions(int index,IntegrationCondition item);
    public A setToConditions(int index,IntegrationCondition item);
    public A addToConditions(IntegrationCondition... items);
    public A addAllToConditions(Collection<IntegrationCondition> items);
    public A removeFromConditions(IntegrationCondition... items);
    public A removeAllFromConditions(Collection<IntegrationCondition> items);
    public A removeMatchingFromConditions(Predicate<IntegrationConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationCondition> getConditions();
    public List<IntegrationCondition> buildConditions();
    public IntegrationCondition buildCondition(int index);
    public IntegrationCondition buildFirstCondition();
    public IntegrationCondition buildLastCondition();
    public IntegrationCondition buildMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
    public A withConditions(List<IntegrationCondition> conditions);
    public A withConditions(IntegrationCondition... conditions);
    public Boolean hasConditions();
    public IntegrationStatusFluent.ConditionsNested<A> addNewCondition();
    public IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationCondition item);
    public IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,IntegrationCondition item);
    public IntegrationStatusFluent.ConditionsNested<A> editCondition(int index);
    public IntegrationStatusFluent.ConditionsNested<A> editFirstCondition();
    public IntegrationStatusFluent.ConditionsNested<A> editLastCondition();
    public IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationConditionBuilder> predicate);
    public A addToConfiguration(int index,ConfigurationSpec item);
    public A setToConfiguration(int index,ConfigurationSpec item);
    public A addToConfiguration(ConfigurationSpec... items);
    public A addAllToConfiguration(Collection<ConfigurationSpec> items);
    public A removeFromConfiguration(ConfigurationSpec... items);
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items);
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration();
    public List<ConfigurationSpec> buildConfiguration();
    public ConfigurationSpec buildConfiguration(int index);
    public ConfigurationSpec buildFirstConfiguration();
    public ConfigurationSpec buildLastConfiguration();
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A withConfiguration(List<ConfigurationSpec> configuration);
    public A withConfiguration(ConfigurationSpec... configuration);
    public Boolean hasConfiguration();
    public A addNewConfiguration(String type,String value);
    public IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration();
    public IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item);
    public IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item);
    public IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(int index);
    public IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration();
    public IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration();
    public IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A addToDependencies(int index,String item);
    public A setToDependencies(int index,String item);
    public A addToDependencies(String... items);
    public A addAllToDependencies(Collection<String> items);
    public A removeFromDependencies(String... items);
    public A removeAllFromDependencies(Collection<String> items);
    public List<String> getDependencies();
    public String getDependency(int index);
    public String getFirstDependency();
    public String getLastDependency();
    public String getMatchingDependency(Predicate<String> predicate);
    public Boolean hasMatchingDependency(Predicate<String> predicate);
    public A withDependencies(List<String> dependencies);
    public A withDependencies(String... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(StringBuilder arg1);
    public A addNewDependency(int[] arg1,int arg2,int arg3);
    public A addNewDependency(char[] arg1);
    public A addNewDependency(StringBuffer arg1);
    public A addNewDependency(byte[] arg1,int arg2);
    public A addNewDependency(byte[] arg1);
    public A addNewDependency(char[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDependency(String arg1);
    public String getDigest();
    public A withDigest(String digest);
    public Boolean hasDigest();
    public A withNewDigest(StringBuilder arg1);
    public A withNewDigest(int[] arg1,int arg2,int arg3);
    public A withNewDigest(char[] arg1);
    public A withNewDigest(StringBuffer arg1);
    public A withNewDigest(byte[] arg1,int arg2);
    public A withNewDigest(byte[] arg1);
    public A withNewDigest(char[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDigest(String arg1);
    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure();
    public Failure buildFailure();
    public A withFailure(Failure failure);
    public Boolean hasFailure();
    public IntegrationStatusFluent.FailureNested<A> withNewFailure();
    public IntegrationStatusFluent.FailureNested<A> withNewFailureLike(Failure item);
    public IntegrationStatusFluent.FailureNested<A> editFailure();
    public IntegrationStatusFluent.FailureNested<A> editOrNewFailure();
    public IntegrationStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item);
    public A addToGeneratedResources(int index,ResourceSpec item);
    public A setToGeneratedResources(int index,ResourceSpec item);
    public A addToGeneratedResources(ResourceSpec... items);
    public A addAllToGeneratedResources(Collection<ResourceSpec> items);
    public A removeFromGeneratedResources(ResourceSpec... items);
    public A removeAllFromGeneratedResources(Collection<ResourceSpec> items);
    public A removeMatchingFromGeneratedResources(Predicate<ResourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGeneratedResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getGeneratedResources();
    public List<ResourceSpec> buildGeneratedResources();
    public ResourceSpec buildGeneratedResource(int index);
    public ResourceSpec buildFirstGeneratedResource();
    public ResourceSpec buildLastGeneratedResource();
    public ResourceSpec buildMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
    public Boolean hasMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
    public A withGeneratedResources(List<ResourceSpec> generatedResources);
    public A withGeneratedResources(ResourceSpec... generatedResources);
    public Boolean hasGeneratedResources();
    public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource();
    public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(ResourceSpec item);
    public IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(int index,ResourceSpec item);
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(int index);
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource();
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource();
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate);
    public A addToGeneratedSources(int index,SourceSpec item);
    public A setToGeneratedSources(int index,SourceSpec item);
    public A addToGeneratedSources(SourceSpec... items);
    public A addAllToGeneratedSources(Collection<SourceSpec> items);
    public A removeFromGeneratedSources(SourceSpec... items);
    public A removeAllFromGeneratedSources(Collection<SourceSpec> items);
    public A removeMatchingFromGeneratedSources(Predicate<SourceSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGeneratedSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getGeneratedSources();
    public List<SourceSpec> buildGeneratedSources();
    public SourceSpec buildGeneratedSource(int index);
    public SourceSpec buildFirstGeneratedSource();
    public SourceSpec buildLastGeneratedSource();
    public SourceSpec buildMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
    public Boolean hasMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
    public A withGeneratedSources(List<SourceSpec> generatedSources);
    public A withGeneratedSources(SourceSpec... generatedSources);
    public Boolean hasGeneratedSources();
    public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource();
    public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(SourceSpec item);
    public IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(int index,SourceSpec item);
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(int index);
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource();
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource();
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getKit();
    public A withKit(String kit);
    public Boolean hasKit();
    public A withNewKit(StringBuilder arg1);
    public A withNewKit(int[] arg1,int arg2,int arg3);
    public A withNewKit(char[] arg1);
    public A withNewKit(StringBuffer arg1);
    public A withNewKit(byte[] arg1,int arg2);
    public A withNewKit(byte[] arg1);
    public A withNewKit(char[] arg1,int arg2,int arg3);
    public A withNewKit(byte[] arg1,int arg2,int arg3);
    public A withNewKit(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKit(String arg1);
    public String getLastInitTimestamp();
    public A withLastInitTimestamp(String lastInitTimestamp);
    public Boolean hasLastInitTimestamp();
    public A withNewLastInitTimestamp(StringBuilder arg1);
    public A withNewLastInitTimestamp(int[] arg1,int arg2,int arg3);
    public A withNewLastInitTimestamp(char[] arg1);
    public A withNewLastInitTimestamp(StringBuffer arg1);
    public A withNewLastInitTimestamp(byte[] arg1,int arg2);
    public A withNewLastInitTimestamp(byte[] arg1);
    public A withNewLastInitTimestamp(char[] arg1,int arg2,int arg3);
    public A withNewLastInitTimestamp(byte[] arg1,int arg2,int arg3);
    public A withNewLastInitTimestamp(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLastInitTimestamp(String arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public String getPlatform();
    public A withPlatform(String platform);
    public Boolean hasPlatform();
    public A withNewPlatform(StringBuilder arg1);
    public A withNewPlatform(int[] arg1,int arg2,int arg3);
    public A withNewPlatform(char[] arg1);
    public A withNewPlatform(StringBuffer arg1);
    public A withNewPlatform(byte[] arg1,int arg2);
    public A withNewPlatform(byte[] arg1);
    public A withNewPlatform(char[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPlatform(String arg1);
    public String getProfile();
    public A withProfile(String profile);
    public Boolean hasProfile();
    public A withNewProfile(StringBuilder arg1);
    public A withNewProfile(int[] arg1,int arg2,int arg3);
    public A withNewProfile(char[] arg1);
    public A withNewProfile(StringBuffer arg1);
    public A withNewProfile(byte[] arg1,int arg2);
    public A withNewProfile(byte[] arg1);
    public A withNewProfile(char[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewProfile(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public String getRuntimeProvider();
    public A withRuntimeProvider(String runtimeProvider);
    public Boolean hasRuntimeProvider();
    public A withNewRuntimeProvider(StringBuilder arg1);
    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(char[] arg1);
    public A withNewRuntimeProvider(StringBuffer arg1);
    public A withNewRuntimeProvider(byte[] arg1,int arg2);
    public A withNewRuntimeProvider(byte[] arg1);
    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeProvider(String arg1);
    public String getRuntimeVersion();
    public A withRuntimeVersion(String runtimeVersion);
    public Boolean hasRuntimeVersion();
    public A withNewRuntimeVersion(StringBuilder arg1);
    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(char[] arg1);
    public A withNewRuntimeVersion(StringBuffer arg1);
    public A withNewRuntimeVersion(byte[] arg1,int arg2);
    public A withNewRuntimeVersion(byte[] arg1);
    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeVersion(String arg1);
    public String getSelector();
    public A withSelector(String selector);
    public Boolean hasSelector();
    public A withNewSelector(StringBuilder arg1);
    public A withNewSelector(int[] arg1,int arg2,int arg3);
    public A withNewSelector(char[] arg1);
    public A withNewSelector(StringBuffer arg1);
    public A withNewSelector(byte[] arg1,int arg2);
    public A withNewSelector(byte[] arg1);
    public A withNewSelector(char[] arg1,int arg2,int arg3);
    public A withNewSelector(byte[] arg1,int arg2,int arg3);
    public A withNewSelector(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSelector(String arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationConditionFluent<IntegrationStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface ConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigurationSpecFluent<IntegrationStatusFluent.ConfigurationNested<N>> {

            public N and();
            public N endConfiguration();    }


    public interface FailureNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FailureFluent<IntegrationStatusFluent.FailureNested<N>> {

            public N and();
            public N endFailure();    }


    public interface GeneratedResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceSpecFluent<IntegrationStatusFluent.GeneratedResourcesNested<N>> {

            public N and();
            public N endGeneratedResource();    }


    public interface GeneratedSourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceSpecFluent<IntegrationStatusFluent.GeneratedSourcesNested<N>> {

            public N and();
            public N endGeneratedSource();    }


}
