package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class IntegrationSpecFluentImpl<A extends IntegrationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationSpecFluent<A> {

    private List<ConfigurationSpecBuilder> configuration;
    private List<String> dependencies;
    private List<JsonNode> flows;
    private String kit;
    private String profile;
    private Integer replicas;
    private List<String> repositories;
    private List<ResourceSpecBuilder> resources;
    private String serviceAccountName;
    private List<SourceSpecBuilder> sources;
    private Map<String,TraitSpec> traits;

    public IntegrationSpecFluentImpl() {
    }

    public IntegrationSpecFluentImpl(IntegrationSpec instance) {
        this.withConfiguration(instance.getConfiguration()); 
        this.withDependencies(instance.getDependencies()); 
        this.withFlows(instance.getFlows()); 
        this.withKit(instance.getKit()); 
        this.withProfile(instance.getProfile()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRepositories(instance.getRepositories()); 
        this.withResources(instance.getResources()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSources(instance.getSources()); 
        this.withTraits(instance.getTraits()); 
    }

    public A addToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(ConfigurationSpec... items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public List<ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(String type,String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public IntegrationSpecFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public IntegrationSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    public IntegrationSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    public IntegrationSpecFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public IntegrationSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public IntegrationSpecFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public IntegrationSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public A addToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(String... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(String... items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<String>(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(StringBuilder arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(int[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(char[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(StringBuffer arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(byte[] arg1,int arg2) {
        return (A)addToDependencies(new String(arg1, arg2));
    }

    public A addNewDependency(byte[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(char[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToDependencies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewDependency(String arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addToFlows(int index,JsonNode item) {
        if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
        this.flows.add(index, item);
        return (A)this;
    }

    public A setToFlows(int index,JsonNode item) {
        if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
        this.flows.set(index, item); return (A)this;
    }

    public A addToFlows(JsonNode... items) {
        if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
        for (JsonNode item : items) {this.flows.add(item);} return (A)this;
    }

    public A addAllToFlows(Collection<JsonNode> items) {
        if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
        for (JsonNode item : items) {this.flows.add(item);} return (A)this;
    }

    public A removeFromFlows(JsonNode... items) {
        for (JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
    }

    public A removeAllFromFlows(Collection<JsonNode> items) {
        for (JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
    }

    public List<JsonNode> getFlows() {
        return this.flows;
    }

    public JsonNode getFlow(int index) {
        return this.flows.get(index);
    }

    public JsonNode getFirstFlow() {
        return this.flows.get(0);
    }

    public JsonNode getLastFlow() {
        return this.flows.get(flows.size() - 1);
    }

    public JsonNode getMatchingFlow(Predicate<JsonNode> predicate) {
        for (JsonNode item: flows) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingFlow(Predicate<JsonNode> predicate) {
        for (JsonNode item: flows) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withFlows(List<JsonNode> flows) {
        if (this.flows != null) { _visitables.get("flows").removeAll(this.flows);}
        if (flows != null) {this.flows = new ArrayList<JsonNode>(); for (JsonNode item : flows){this.addToFlows(item);}} else { this.flows = null;} return (A) this;
    }

    public A withFlows(JsonNode... flows) {
        if (this.flows != null) {this.flows.clear();}
        if (flows != null) {for (JsonNode item :flows){ this.addToFlows(item);}} return (A) this;
    }

    public Boolean hasFlows() {
        return flows != null && !flows.isEmpty();
    }

    public String getKit() {
        return this.kit;
    }

    public A withKit(String kit) {
        this.kit=kit; return (A) this;
    }

    public Boolean hasKit() {
        return this.kit != null;
    }

    public A withNewKit(StringBuilder arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(int[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(char[] arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(StringBuffer arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(byte[] arg1,int arg2) {
        return (A)withKit(new String(arg1, arg2));
    }

    public A withNewKit(byte[] arg1) {
        return (A)withKit(new String(arg1));
    }

    public A withNewKit(char[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(byte[] arg1,int arg2,int arg3) {
        return (A)withKit(new String(arg1, arg2, arg3));
    }

    public A withNewKit(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKit(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKit(String arg1) {
        return (A)withKit(new String(arg1));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile=profile; return (A) this;
    }

    public Boolean hasProfile() {
        return this.profile != null;
    }

    public A withNewProfile(StringBuilder arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(int[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(char[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuffer arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(byte[] arg1,int arg2) {
        return (A)withProfile(new String(arg1, arg2));
    }

    public A withNewProfile(byte[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(char[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProfile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProfile(String arg1) {
        return (A)withProfile(new String(arg1));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A withNewReplicas(int arg1) {
        return (A)withReplicas(new Integer(arg1));
    }

    public A addToRepositories(int index,String item) {
        if (this.repositories == null) {this.repositories = new ArrayList<String>();}
        this.repositories.add(index, item);
        return (A)this;
    }

    public A setToRepositories(int index,String item) {
        if (this.repositories == null) {this.repositories = new ArrayList<String>();}
        this.repositories.set(index, item); return (A)this;
    }

    public A addToRepositories(String... items) {
        if (this.repositories == null) {this.repositories = new ArrayList<String>();}
        for (String item : items) {this.repositories.add(item);} return (A)this;
    }

    public A addAllToRepositories(Collection<String> items) {
        if (this.repositories == null) {this.repositories = new ArrayList<String>();}
        for (String item : items) {this.repositories.add(item);} return (A)this;
    }

    public A removeFromRepositories(String... items) {
        for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
    }

    public A removeAllFromRepositories(Collection<String> items) {
        for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public String getRepository(int index) {
        return this.repositories.get(index);
    }

    public String getFirstRepository() {
        return this.repositories.get(0);
    }

    public String getLastRepository() {
        return this.repositories.get(repositories.size() - 1);
    }

    public String getMatchingRepository(Predicate<String> predicate) {
        for (String item: repositories) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRepository(Predicate<String> predicate) {
        for (String item: repositories) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRepositories(List<String> repositories) {
        if (this.repositories != null) { _visitables.get("repositories").removeAll(this.repositories);}
        if (repositories != null) {this.repositories = new ArrayList<String>(); for (String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
    }

    public A withRepositories(String... repositories) {
        if (this.repositories != null) {this.repositories.clear();}
        if (repositories != null) {for (String item :repositories){ this.addToRepositories(item);}} return (A) this;
    }

    public Boolean hasRepositories() {
        return repositories != null && !repositories.isEmpty();
    }

    public A addNewRepository(StringBuilder arg1) {
        return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(int[] arg1,int arg2,int arg3) {
        return (A)addToRepositories(new String(arg1, arg2, arg3));
    }

    public A addNewRepository(char[] arg1) {
        return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(StringBuffer arg1) {
        return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(byte[] arg1,int arg2) {
        return (A)addToRepositories(new String(arg1, arg2));
    }

    public A addNewRepository(byte[] arg1) {
        return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(char[] arg1,int arg2,int arg3) {
        return (A)addToRepositories(new String(arg1, arg2, arg3));
    }

    public A addNewRepository(byte[] arg1,int arg2,int arg3) {
        return (A)addToRepositories(new String(arg1, arg2, arg3));
    }

    public A addNewRepository(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToRepositories(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewRepository(String arg1) {
        return (A)addToRepositories(new String(arg1));
    }

    public A addToResources(int index,ResourceSpec item) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,ResourceSpec item) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
        if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
         return (A)this;
    }

    public A addToResources(ResourceSpec... items) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<ResourceSpec> items) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(ResourceSpec... items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
        if (resources == null) return (A) this;
        final Iterator<ResourceSpecBuilder> each = resources.iterator();
        final List visitables = _visitables.get("resources");
        while (each.hasNext()) {
          ResourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getResources() {
        return build(resources);
    }

    public List<ResourceSpec> buildResources() {
        return build(resources);
    }

    public ResourceSpec buildResource(int index) {
        return this.resources.get(index).build();
    }

    public ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    public ResourceSpec buildLastResource() {
        return this.resources.get(resources.size() - 1).build();
    }

    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResources(List<ResourceSpec> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new ArrayList<ResourceSpecBuilder>(); for (ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(ResourceSpec... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public IntegrationSpecFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    public IntegrationSpecFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
        return new ResourcesNestedImpl(-1, item);
    }

    public IntegrationSpecFluent.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item) {
        return new ResourcesNestedImpl(index, item);
    }

    public IntegrationSpecFluent.ResourcesNested<A> editResource(int index) {
        if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
        return setNewResourceLike(index, buildResource(index));
    }

    public IntegrationSpecFluent.ResourcesNested<A> editFirstResource() {
        if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
        return setNewResourceLike(0, buildResource(0));
    }

    public IntegrationSpecFluent.ResourcesNested<A> editLastResource() {
        int index = resources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
        return setNewResourceLike(index, buildResource(index));
    }

    public IntegrationSpecFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resources.size();i++) { 
        if (predicate.test(resources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
        return setNewResourceLike(index, buildResource(index));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(char[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2) {
        return (A)withServiceAccountName(new String(arg1, arg2));
    }

    public A withNewServiceAccountName(byte[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A addToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(SourceSpec... items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(SourceSpec... items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<SourceSpecBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          SourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getSources() {
        return build(sources);
    }

    public List<SourceSpec> buildSources() {
        return build(sources);
    }

    public SourceSpec buildSource(int index) {
        return this.sources.get(index).build();
    }

    public SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    public SourceSpec buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new ArrayList<SourceSpecBuilder>(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(SourceSpec... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
    }

    public Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public IntegrationSpecFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    public IntegrationSpecFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
        return new SourcesNestedImpl(-1, item);
    }

    public IntegrationSpecFluent.SourcesNested<A> setNewSourceLike(int index,SourceSpec item) {
        return new SourcesNestedImpl(index, item);
    }

    public IntegrationSpecFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public IntegrationSpecFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public IntegrationSpecFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public IntegrationSpecFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public A addToTraits(String key,TraitSpec value) {
        if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
    }

    public A addToTraits(Map<String,TraitSpec> map) {
        if(this.traits == null && map != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(map != null) { this.traits.putAll(map);} return (A)this;
    }

    public A removeFromTraits(String key) {
        if(this.traits == null) { return (A) this; }
        if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
    }

    public A removeFromTraits(Map<String,TraitSpec> map) {
        if(this.traits == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
    }

    public Map<String,TraitSpec> getTraits() {
        return this.traits;
    }

    public <K extends Object,V extends Object>A withTraits(Map<String,TraitSpec> traits) {
        if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap<String,TraitSpec>(traits);} return (A) this;
    }

    public Boolean hasTraits() {
        return this.traits != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationSpecFluentImpl that = (IntegrationSpecFluentImpl) o;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (flows != null ? !flows.equals(that.flows) :that.flows != null) return false;
        if (kit != null ? !kit.equals(that.kit) :that.kit != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(configuration,  dependencies,  flows,  kit,  profile,  replicas,  repositories,  resources,  serviceAccountName,  sources,  traits,  super.hashCode());
    }

    public class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationSpecFluent.ConfigurationNested<N>> implements IntegrationSpecFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,ConfigurationSpec item) {
                this.index = index;
                this.builder = new ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationSpecFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends ResourceSpecFluentImpl<IntegrationSpecFluent.ResourcesNested<N>> implements IntegrationSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceSpecBuilder builder;
        private final int index;

            ResourcesNestedImpl(int index,ResourceSpec item) {
                this.index = index;
                this.builder = new ResourceSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.index = -1;
                this.builder = new ResourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationSpecFluentImpl.this.setToResources(index,builder.build());
            }

            public N endResource() {
                return and();
            }
    }


    public class SourcesNestedImpl<N> extends SourceSpecFluentImpl<IntegrationSpecFluent.SourcesNested<N>> implements IntegrationSpecFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SourceSpecBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,SourceSpec item) {
                this.index = index;
                this.builder = new SourceSpecBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new SourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationSpecFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
