package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IntegrationPlatformKameletSpecFluentImpl<A extends IntegrationPlatformKameletSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationPlatformKameletSpecFluent<A> {

    private List<IntegrationPlatformKameletRepositorySpecBuilder> repositories;

    public IntegrationPlatformKameletSpecFluentImpl() {
    }

    public IntegrationPlatformKameletSpecFluentImpl(IntegrationPlatformKameletSpec instance) {
        this.withRepositories(instance.getRepositories()); 
    }

    public A addToRepositories(int index,IntegrationPlatformKameletRepositorySpec item) {
        if (this.repositories == null) {this.repositories = new ArrayList<IntegrationPlatformKameletRepositorySpecBuilder>();}
        IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);_visitables.get("repositories").add(index >= 0 ? index : _visitables.get("repositories").size(), builder);this.repositories.add(index >= 0 ? index : repositories.size(), builder); return (A)this;
    }

    public A setToRepositories(int index,IntegrationPlatformKameletRepositorySpec item) {
        if (this.repositories == null) {this.repositories = new ArrayList<IntegrationPlatformKameletRepositorySpecBuilder>();}
        IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);
        if (index < 0 || index >= _visitables.get("repositories").size()) { _visitables.get("repositories").add(builder); } else { _visitables.get("repositories").set(index, builder);}
        if (index < 0 || index >= repositories.size()) { repositories.add(builder); } else { repositories.set(index, builder);}
         return (A)this;
    }

    public A addToRepositories(IntegrationPlatformKameletRepositorySpec... items) {
        if (this.repositories == null) {this.repositories = new ArrayList<IntegrationPlatformKameletRepositorySpecBuilder>();}
        for (IntegrationPlatformKameletRepositorySpec item : items) {IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
    }

    public A addAllToRepositories(Collection<IntegrationPlatformKameletRepositorySpec> items) {
        if (this.repositories == null) {this.repositories = new ArrayList<IntegrationPlatformKameletRepositorySpecBuilder>();}
        for (IntegrationPlatformKameletRepositorySpec item : items) {IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
    }

    public A removeFromRepositories(IntegrationPlatformKameletRepositorySpec... items) {
        for (IntegrationPlatformKameletRepositorySpec item : items) {IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
    }

    public A removeAllFromRepositories(Collection<IntegrationPlatformKameletRepositorySpec> items) {
        for (IntegrationPlatformKameletRepositorySpec item : items) {IntegrationPlatformKameletRepositorySpecBuilder builder = new IntegrationPlatformKameletRepositorySpecBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRepositories(Predicate<IntegrationPlatformKameletRepositorySpecBuilder> predicate) {
        if (repositories == null) return (A) this;
        final Iterator<IntegrationPlatformKameletRepositorySpecBuilder> each = repositories.iterator();
        final List visitables = _visitables.get("repositories");
        while (each.hasNext()) {
          IntegrationPlatformKameletRepositorySpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRepositories instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationPlatformKameletRepositorySpec> getRepositories() {
        return build(repositories);
    }

    public List<IntegrationPlatformKameletRepositorySpec> buildRepositories() {
        return build(repositories);
    }

    public IntegrationPlatformKameletRepositorySpec buildRepository(int index) {
        return this.repositories.get(index).build();
    }

    public IntegrationPlatformKameletRepositorySpec buildFirstRepository() {
        return this.repositories.get(0).build();
    }

    public IntegrationPlatformKameletRepositorySpec buildLastRepository() {
        return this.repositories.get(repositories.size() - 1).build();
    }

    public IntegrationPlatformKameletRepositorySpec buildMatchingRepository(Predicate<IntegrationPlatformKameletRepositorySpecBuilder> predicate) {
        for (IntegrationPlatformKameletRepositorySpecBuilder item: repositories) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRepository(Predicate<IntegrationPlatformKameletRepositorySpecBuilder> predicate) {
        for (IntegrationPlatformKameletRepositorySpecBuilder item: repositories) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRepositories(List<IntegrationPlatformKameletRepositorySpec> repositories) {
        if (this.repositories != null) { _visitables.get("repositories").removeAll(this.repositories);}
        if (repositories != null) {this.repositories = new ArrayList<IntegrationPlatformKameletRepositorySpecBuilder>(); for (IntegrationPlatformKameletRepositorySpec item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
    }

    public A withRepositories(IntegrationPlatformKameletRepositorySpec... repositories) {
        if (this.repositories != null) {this.repositories.clear();}
        if (repositories != null) {for (IntegrationPlatformKameletRepositorySpec item :repositories){ this.addToRepositories(item);}} return (A) this;
    }

    public Boolean hasRepositories() {
        return repositories != null && !repositories.isEmpty();
    }

    public A addNewRepository(String uri) {
        return (A)addToRepositories(new IntegrationPlatformKameletRepositorySpec(uri));
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> addNewRepository() {
        return new RepositoriesNestedImpl();
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> addNewRepositoryLike(IntegrationPlatformKameletRepositorySpec item) {
        return new RepositoriesNestedImpl(-1, item);
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> setNewRepositoryLike(int index,IntegrationPlatformKameletRepositorySpec item) {
        return new RepositoriesNestedImpl(index, item);
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> editRepository(int index) {
        if (repositories.size() <= index) throw new RuntimeException("Can't edit repositories. Index exceeds size.");
        return setNewRepositoryLike(index, buildRepository(index));
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> editFirstRepository() {
        if (repositories.size() == 0) throw new RuntimeException("Can't edit first repositories. The list is empty.");
        return setNewRepositoryLike(0, buildRepository(0));
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> editLastRepository() {
        int index = repositories.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last repositories. The list is empty.");
        return setNewRepositoryLike(index, buildRepository(index));
    }

    public IntegrationPlatformKameletSpecFluent.RepositoriesNested<A> editMatchingRepository(Predicate<IntegrationPlatformKameletRepositorySpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<repositories.size();i++) { 
        if (predicate.test(repositories.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching repositories. No match found.");
        return setNewRepositoryLike(index, buildRepository(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformKameletSpecFluentImpl that = (IntegrationPlatformKameletSpecFluentImpl) o;
        if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(repositories,  super.hashCode());
    }

    public class RepositoriesNestedImpl<N> extends IntegrationPlatformKameletRepositorySpecFluentImpl<IntegrationPlatformKameletSpecFluent.RepositoriesNested<N>> implements IntegrationPlatformKameletSpecFluent.RepositoriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformKameletRepositorySpecBuilder builder;
        private final int index;

            RepositoriesNestedImpl(int index,IntegrationPlatformKameletRepositorySpec item) {
                this.index = index;
                this.builder = new IntegrationPlatformKameletRepositorySpecBuilder(this, item);
                        
            }

            RepositoriesNestedImpl() {
                this.index = -1;
                this.builder = new IntegrationPlatformKameletRepositorySpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformKameletSpecFluentImpl.this.setToRepositories(index,builder.build());
            }

            public N endRepository() {
                return and();
            }
    }


}
