package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class IntegrationKitStatusFluentImpl<A extends IntegrationKitStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationKitStatusFluent<A> {

    private List<ArtifactBuilder> artifacts;
    private String baseImage;
    private List<IntegrationKitConditionBuilder> conditions;
    private String digest;
    private FailureBuilder failure;
    private String image;
    private String phase;
    private String platform;
    private String runtimeProvider;
    private String runtimeVersion;
    private String version;

    public IntegrationKitStatusFluentImpl() {
    }

    public IntegrationKitStatusFluentImpl(IntegrationKitStatus instance) {
        this.withArtifacts(instance.getArtifacts()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConditions(instance.getConditions()); 
        this.withDigest(instance.getDigest()); 
        this.withFailure(instance.getFailure()); 
        this.withImage(instance.getImage()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withVersion(instance.getVersion()); 
    }

    public A addToArtifacts(int index,Artifact item) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToArtifacts(int index,Artifact item) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToArtifacts(Artifact... items) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToArtifacts(Collection<Artifact> items) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromArtifacts(Artifact... items) {
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromArtifacts(Collection<Artifact> items) {
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<ArtifactBuilder> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          ArtifactBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildArtifacts instead.
 * @return The buildable object.
 */
@Deprecated public List<Artifact> getArtifacts() {
        return build(artifacts);
    }

    public List<Artifact> buildArtifacts() {
        return build(artifacts);
    }

    public Artifact buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    public Artifact buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    public Artifact buildLastArtifact() {
        return this.artifacts.get(artifacts.size() - 1).build();
    }

    public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArtifacts(List<Artifact> artifacts) {
        if (this.artifacts != null) { _visitables.get("artifacts").removeAll(this.artifacts);}
        if (artifacts != null) {this.artifacts = new ArrayList<ArtifactBuilder>(); for (Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
    }

    public A withArtifacts(Artifact... artifacts) {
        if (this.artifacts != null) {this.artifacts.clear();}
        if (artifacts != null) {for (Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
    }

    public Boolean hasArtifacts() {
        return artifacts != null && !artifacts.isEmpty();
    }

    public A addNewArtifact(String checksum,String id,String location,String target) {
        return (A)addToArtifacts(new Artifact(checksum, id, location, target));
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifact() {
        return new ArtifactsNestedImpl();
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item) {
        return new ArtifactsNestedImpl(-1, item);
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item) {
        return new ArtifactsNestedImpl(index, item);
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> editArtifact(int index) {
        if (artifacts.size() <= index) throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> editFirstArtifact() {
        if (artifacts.size() == 0) throw new RuntimeException("Can't edit first artifacts. The list is empty.");
        return setNewArtifactLike(0, buildArtifact(0));
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> editLastArtifact() {
        int index = artifacts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last artifacts. The list is empty.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public IntegrationKitStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        int index = -1;
        for (int i=0;i<artifacts.size();i++) { 
        if (predicate.test(artifacts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching artifacts. No match found.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A addToConditions(int index,IntegrationKitCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
        IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,IntegrationKitCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
        IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(IntegrationKitCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
        for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<IntegrationKitCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
        for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(IntegrationKitCondition... items) {
        for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<IntegrationKitCondition> items) {
        for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<IntegrationKitConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<IntegrationKitConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          IntegrationKitConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationKitCondition> getConditions() {
        return build(conditions);
    }

    public List<IntegrationKitCondition> buildConditions() {
        return build(conditions);
    }

    public IntegrationKitCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public IntegrationKitCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public IntegrationKitCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public IntegrationKitCondition buildMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        for (IntegrationKitConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        for (IntegrationKitConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<IntegrationKitCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>(); for (IntegrationKitCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(IntegrationKitCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (IntegrationKitCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationKitCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> setNewConditionLike(int index,IntegrationKitCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public IntegrationKitStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getDigest() {
        return this.digest;
    }

    public A withDigest(String digest) {
        this.digest=digest; return (A) this;
    }

    public Boolean hasDigest() {
        return this.digest != null;
    }

    public A withNewDigest(StringBuilder arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(int[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(char[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(StringBuffer arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(byte[] arg1,int arg2) {
        return (A)withDigest(new String(arg1, arg2));
    }

    public A withNewDigest(byte[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(char[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDigest(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDigest(String arg1) {
        return (A)withDigest(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public Failure buildFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public A withFailure(Failure failure) {
        _visitables.get("failure").remove(this.failure);
        if (failure!=null){ this.failure= new FailureBuilder(failure); _visitables.get("failure").add(this.failure);} return (A) this;
    }

    public Boolean hasFailure() {
        return this.failure != null;
    }

    public IntegrationKitStatusFluent.FailureNested<A> withNewFailure() {
        return new FailureNestedImpl();
    }

    public IntegrationKitStatusFluent.FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNestedImpl(item);
    }

    public IntegrationKitStatusFluent.FailureNested<A> editFailure() {
        return withNewFailureLike(getFailure());
    }

    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailure() {
        return withNewFailureLike(getFailure() != null ? getFailure(): new FailureBuilder().build());
    }

    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item) {
        return withNewFailureLike(getFailure() != null ? getFailure(): item);
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform=platform; return (A) this;
    }

    public Boolean hasPlatform() {
        return this.platform != null;
    }

    public A withNewPlatform(StringBuilder arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(int[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(char[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(StringBuffer arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(byte[] arg1,int arg2) {
        return (A)withPlatform(new String(arg1, arg2));
    }

    public A withNewPlatform(byte[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(char[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPlatform(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPlatform(String arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider=runtimeProvider; return (A) this;
    }

    public Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public A withNewRuntimeProvider(StringBuilder arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(char[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(StringBuffer arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2) {
        return (A)withRuntimeProvider(new String(arg1, arg2));
    }

    public A withNewRuntimeProvider(byte[] arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeProvider(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeProvider(String arg1) {
        return (A)withRuntimeProvider(new String(arg1));
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion=runtimeVersion; return (A) this;
    }

    public Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public A withNewRuntimeVersion(StringBuilder arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(char[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(StringBuffer arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2) {
        return (A)withRuntimeVersion(new String(arg1, arg2));
    }

    public A withNewRuntimeVersion(byte[] arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeVersion(String arg1) {
        return (A)withRuntimeVersion(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationKitStatusFluentImpl that = (IntegrationKitStatusFluentImpl) o;
        if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
        if (failure != null ? !failure.equals(that.failure) :that.failure != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (runtimeProvider != null ? !runtimeProvider.equals(that.runtimeProvider) :that.runtimeProvider != null) return false;
        if (runtimeVersion != null ? !runtimeVersion.equals(that.runtimeVersion) :that.runtimeVersion != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifacts,  baseImage,  conditions,  digest,  failure,  image,  phase,  platform,  runtimeProvider,  runtimeVersion,  version,  super.hashCode());
    }

    public class ArtifactsNestedImpl<N> extends ArtifactFluentImpl<IntegrationKitStatusFluent.ArtifactsNested<N>> implements IntegrationKitStatusFluent.ArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ArtifactBuilder builder;
        private final int index;

            ArtifactsNestedImpl(int index,Artifact item) {
                this.index = index;
                this.builder = new ArtifactBuilder(this, item);
                        
            }

            ArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new ArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitStatusFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endArtifact() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends IntegrationKitConditionFluentImpl<IntegrationKitStatusFluent.ConditionsNested<N>> implements IntegrationKitStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationKitConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,IntegrationKitCondition item) {
                this.index = index;
                this.builder = new IntegrationKitConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new IntegrationKitConditionBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class FailureNestedImpl<N> extends FailureFluentImpl<IntegrationKitStatusFluent.FailureNested<N>> implements IntegrationKitStatusFluent.FailureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FailureBuilder builder;

            FailureNestedImpl(Failure item) {
                this.builder = new FailureBuilder(this, item);
                        
            }

            FailureNestedImpl() {
                this.builder = new FailureBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitStatusFluentImpl.this.withFailure(builder.build());
            }

            public N endFailure() {
                return and();
            }
    }


}
