package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface IntegrationKitStatusFluent<A extends IntegrationKitStatusFluent<A>> extends Fluent<A> {


    public A addToArtifacts(int index,Artifact item);
    public A setToArtifacts(int index,Artifact item);
    public A addToArtifacts(Artifact... items);
    public A addAllToArtifacts(Collection<Artifact> items);
    public A removeFromArtifacts(Artifact... items);
    public A removeAllFromArtifacts(Collection<Artifact> items);
    public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildArtifacts instead.
 * @return The buildable object.
 */
@Deprecated public List<Artifact> getArtifacts();
    public List<Artifact> buildArtifacts();
    public Artifact buildArtifact(int index);
    public Artifact buildFirstArtifact();
    public Artifact buildLastArtifact();
    public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public A withArtifacts(List<Artifact> artifacts);
    public A withArtifacts(Artifact... artifacts);
    public Boolean hasArtifacts();
    public A addNewArtifact(String checksum,String id,String location,String target);
    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifact();
    public IntegrationKitStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item);
    public IntegrationKitStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item);
    public IntegrationKitStatusFluent.ArtifactsNested<A> editArtifact(int index);
    public IntegrationKitStatusFluent.ArtifactsNested<A> editFirstArtifact();
    public IntegrationKitStatusFluent.ArtifactsNested<A> editLastArtifact();
    public IntegrationKitStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(int[] arg1,int arg2,int arg3);
    public A withNewBaseImage(char[] arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A withNewBaseImage(byte[] arg1,int arg2);
    public A withNewBaseImage(byte[] arg1);
    public A withNewBaseImage(char[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBaseImage(String arg1);
    public A addToConditions(int index,IntegrationKitCondition item);
    public A setToConditions(int index,IntegrationKitCondition item);
    public A addToConditions(IntegrationKitCondition... items);
    public A addAllToConditions(Collection<IntegrationKitCondition> items);
    public A removeFromConditions(IntegrationKitCondition... items);
    public A removeAllFromConditions(Collection<IntegrationKitCondition> items);
    public A removeMatchingFromConditions(Predicate<IntegrationKitConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationKitCondition> getConditions();
    public List<IntegrationKitCondition> buildConditions();
    public IntegrationKitCondition buildCondition(int index);
    public IntegrationKitCondition buildFirstCondition();
    public IntegrationKitCondition buildLastCondition();
    public IntegrationKitCondition buildMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate);
    public A withConditions(List<IntegrationKitCondition> conditions);
    public A withConditions(IntegrationKitCondition... conditions);
    public Boolean hasConditions();
    public IntegrationKitStatusFluent.ConditionsNested<A> addNewCondition();
    public IntegrationKitStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationKitCondition item);
    public IntegrationKitStatusFluent.ConditionsNested<A> setNewConditionLike(int index,IntegrationKitCondition item);
    public IntegrationKitStatusFluent.ConditionsNested<A> editCondition(int index);
    public IntegrationKitStatusFluent.ConditionsNested<A> editFirstCondition();
    public IntegrationKitStatusFluent.ConditionsNested<A> editLastCondition();
    public IntegrationKitStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate);
    public String getDigest();
    public A withDigest(String digest);
    public Boolean hasDigest();
    public A withNewDigest(StringBuilder arg1);
    public A withNewDigest(int[] arg1,int arg2,int arg3);
    public A withNewDigest(char[] arg1);
    public A withNewDigest(StringBuffer arg1);
    public A withNewDigest(byte[] arg1,int arg2);
    public A withNewDigest(byte[] arg1);
    public A withNewDigest(char[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDigest(String arg1);
    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure();
    public Failure buildFailure();
    public A withFailure(Failure failure);
    public Boolean hasFailure();
    public IntegrationKitStatusFluent.FailureNested<A> withNewFailure();
    public IntegrationKitStatusFluent.FailureNested<A> withNewFailureLike(Failure item);
    public IntegrationKitStatusFluent.FailureNested<A> editFailure();
    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailure();
    public IntegrationKitStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public String getPlatform();
    public A withPlatform(String platform);
    public Boolean hasPlatform();
    public A withNewPlatform(StringBuilder arg1);
    public A withNewPlatform(int[] arg1,int arg2,int arg3);
    public A withNewPlatform(char[] arg1);
    public A withNewPlatform(StringBuffer arg1);
    public A withNewPlatform(byte[] arg1,int arg2);
    public A withNewPlatform(byte[] arg1);
    public A withNewPlatform(char[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPlatform(String arg1);
    public String getRuntimeProvider();
    public A withRuntimeProvider(String runtimeProvider);
    public Boolean hasRuntimeProvider();
    public A withNewRuntimeProvider(StringBuilder arg1);
    public A withNewRuntimeProvider(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(char[] arg1);
    public A withNewRuntimeProvider(StringBuffer arg1);
    public A withNewRuntimeProvider(byte[] arg1,int arg2);
    public A withNewRuntimeProvider(byte[] arg1);
    public A withNewRuntimeProvider(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeProvider(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeProvider(String arg1);
    public String getRuntimeVersion();
    public A withRuntimeVersion(String runtimeVersion);
    public Boolean hasRuntimeVersion();
    public A withNewRuntimeVersion(StringBuilder arg1);
    public A withNewRuntimeVersion(int[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(char[] arg1);
    public A withNewRuntimeVersion(StringBuffer arg1);
    public A withNewRuntimeVersion(byte[] arg1,int arg2);
    public A withNewRuntimeVersion(byte[] arg1);
    public A withNewRuntimeVersion(char[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3);
    public A withNewRuntimeVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRuntimeVersion(String arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ArtifactFluent<IntegrationKitStatusFluent.ArtifactsNested<N>> {

            public N and();
            public N endArtifact();    }


    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationKitConditionFluent<IntegrationKitStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface FailureNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FailureFluent<IntegrationKitStatusFluent.FailureNested<N>> {

            public N and();
            public N endFailure();    }


}
