package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface IntegrationKitSpecFluent<A extends IntegrationKitSpecFluent<A>> extends Fluent<A> {


    public A addToConfiguration(int index,ConfigurationSpec item);
    public A setToConfiguration(int index,ConfigurationSpec item);
    public A addToConfiguration(ConfigurationSpec... items);
    public A addAllToConfiguration(Collection<ConfigurationSpec> items);
    public A removeFromConfiguration(ConfigurationSpec... items);
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items);
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration();
    public List<ConfigurationSpec> buildConfiguration();
    public ConfigurationSpec buildConfiguration(int index);
    public ConfigurationSpec buildFirstConfiguration();
    public ConfigurationSpec buildLastConfiguration();
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A withConfiguration(List<ConfigurationSpec> configuration);
    public A withConfiguration(ConfigurationSpec... configuration);
    public Boolean hasConfiguration();
    public A addNewConfiguration(String type,String value);
    public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfiguration();
    public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item);
    public IntegrationKitSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item);
    public IntegrationKitSpecFluent.ConfigurationNested<A> editConfiguration(int index);
    public IntegrationKitSpecFluent.ConfigurationNested<A> editFirstConfiguration();
    public IntegrationKitSpecFluent.ConfigurationNested<A> editLastConfiguration();
    public IntegrationKitSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate);
    public A addToDependencies(int index,String item);
    public A setToDependencies(int index,String item);
    public A addToDependencies(String... items);
    public A addAllToDependencies(Collection<String> items);
    public A removeFromDependencies(String... items);
    public A removeAllFromDependencies(Collection<String> items);
    public List<String> getDependencies();
    public String getDependency(int index);
    public String getFirstDependency();
    public String getLastDependency();
    public String getMatchingDependency(Predicate<String> predicate);
    public Boolean hasMatchingDependency(Predicate<String> predicate);
    public A withDependencies(List<String> dependencies);
    public A withDependencies(String... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(StringBuilder arg1);
    public A addNewDependency(int[] arg1,int arg2,int arg3);
    public A addNewDependency(char[] arg1);
    public A addNewDependency(StringBuffer arg1);
    public A addNewDependency(byte[] arg1,int arg2);
    public A addNewDependency(byte[] arg1);
    public A addNewDependency(char[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3);
    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewDependency(String arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getProfile();
    public A withProfile(String profile);
    public Boolean hasProfile();
    public A withNewProfile(StringBuilder arg1);
    public A withNewProfile(int[] arg1,int arg2,int arg3);
    public A withNewProfile(char[] arg1);
    public A withNewProfile(StringBuffer arg1);
    public A withNewProfile(byte[] arg1,int arg2);
    public A withNewProfile(byte[] arg1);
    public A withNewProfile(char[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3);
    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewProfile(String arg1);
    public A addToRepositories(int index,String item);
    public A setToRepositories(int index,String item);
    public A addToRepositories(String... items);
    public A addAllToRepositories(Collection<String> items);
    public A removeFromRepositories(String... items);
    public A removeAllFromRepositories(Collection<String> items);
    public List<String> getRepositories();
    public String getRepository(int index);
    public String getFirstRepository();
    public String getLastRepository();
    public String getMatchingRepository(Predicate<String> predicate);
    public Boolean hasMatchingRepository(Predicate<String> predicate);
    public A withRepositories(List<String> repositories);
    public A withRepositories(String... repositories);
    public Boolean hasRepositories();
    public A addNewRepository(StringBuilder arg1);
    public A addNewRepository(int[] arg1,int arg2,int arg3);
    public A addNewRepository(char[] arg1);
    public A addNewRepository(StringBuffer arg1);
    public A addNewRepository(byte[] arg1,int arg2);
    public A addNewRepository(byte[] arg1);
    public A addNewRepository(char[] arg1,int arg2,int arg3);
    public A addNewRepository(byte[] arg1,int arg2,int arg3);
    public A addNewRepository(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewRepository(String arg1);
    public A addToTraits(String key,TraitSpec value);
    public A addToTraits(Map<String,TraitSpec> map);
    public A removeFromTraits(String key);
    public A removeFromTraits(Map<String,TraitSpec> map);
    public Map<String,TraitSpec> getTraits();
    public <K extends Object,V extends Object>A withTraits(Map<String,TraitSpec> traits);
    public Boolean hasTraits();
    public interface ConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigurationSpecFluent<IntegrationKitSpecFluent.ConfigurationNested<N>> {

            public N and();
            public N endConfiguration();    }


}
