package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class IntegrationKitFluentImpl<A extends IntegrationKitFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationKitFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private IntegrationKitSpecBuilder spec;
    private IntegrationKitStatusBuilder status;

    public IntegrationKitFluentImpl() {
    }

    public IntegrationKitFluentImpl(IntegrationKit instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public IntegrationKitFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public IntegrationKitFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public IntegrationKitFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public IntegrationKitFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public IntegrationKitFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationKitSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public IntegrationKitSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(IntegrationKitSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new IntegrationKitSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public IntegrationKitFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public IntegrationKitFluent.SpecNested<A> withNewSpecLike(IntegrationKitSpec item) {
        return new SpecNestedImpl(item);
    }

    public IntegrationKitFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public IntegrationKitFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new IntegrationKitSpecBuilder().build());
    }

    public IntegrationKitFluent.SpecNested<A> editOrNewSpecLike(IntegrationKitSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationKitStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public IntegrationKitStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(IntegrationKitStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new IntegrationKitStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public IntegrationKitFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public IntegrationKitFluent.StatusNested<A> withNewStatusLike(IntegrationKitStatus item) {
        return new StatusNestedImpl(item);
    }

    public IntegrationKitFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public IntegrationKitFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new IntegrationKitStatusBuilder().build());
    }

    public IntegrationKitFluent.StatusNested<A> editOrNewStatusLike(IntegrationKitStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationKitFluentImpl that = (IntegrationKitFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<IntegrationKitFluent.MetadataNested<N>> implements IntegrationKitFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends IntegrationKitSpecFluentImpl<IntegrationKitFluent.SpecNested<N>> implements IntegrationKitFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationKitSpecBuilder builder;

            SpecNestedImpl(IntegrationKitSpec item) {
                this.builder = new IntegrationKitSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new IntegrationKitSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends IntegrationKitStatusFluentImpl<IntegrationKitFluent.StatusNested<N>> implements IntegrationKitFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationKitStatusBuilder builder;

            StatusNestedImpl(IntegrationKitStatus item) {
                this.builder = new IntegrationKitStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new IntegrationKitStatusBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationKitFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
