package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FailureRecoveryBuilder extends FailureRecoveryFluentImpl<FailureRecoveryBuilder> implements VisitableBuilder<FailureRecovery,FailureRecoveryBuilder> {

    FailureRecoveryFluent<?> fluent;
    Boolean validationEnabled;

    public FailureRecoveryBuilder() {
        this(true);
    }

    public FailureRecoveryBuilder(Boolean validationEnabled) {
        this(new FailureRecovery(), validationEnabled);
    }

    public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent) {
        this(fluent, true);
    }

    public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FailureRecovery(), validationEnabled);
    }

    public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,FailureRecovery instance) {
        this(fluent, instance, true);
    }

    public FailureRecoveryBuilder(FailureRecoveryFluent<?> fluent,FailureRecovery instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttempt(instance.getAttempt()); 
        fluent.withAttemptMax(instance.getAttemptMax()); 
        fluent.withAttemptTime(instance.getAttemptTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public FailureRecoveryBuilder(FailureRecovery instance) {
        this(instance,true);
    }

    public FailureRecoveryBuilder(FailureRecovery instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttempt(instance.getAttempt()); 
        this.withAttemptMax(instance.getAttemptMax()); 
        this.withAttemptTime(instance.getAttemptTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableFailureRecovery build() {
        EditableFailureRecovery buildable = new EditableFailureRecovery(fluent.getAttempt(),fluent.getAttemptMax(),fluent.getAttemptTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FailureRecoveryBuilder that = (FailureRecoveryBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
