package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelSchemeBuilder extends CamelSchemeFluentImpl<CamelSchemeBuilder> implements VisitableBuilder<CamelScheme,CamelSchemeBuilder> {

    CamelSchemeFluent<?> fluent;
    Boolean validationEnabled;

    public CamelSchemeBuilder() {
        this(true);
    }

    public CamelSchemeBuilder(Boolean validationEnabled) {
        this(new CamelScheme(), validationEnabled);
    }

    public CamelSchemeBuilder(CamelSchemeFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelScheme(), validationEnabled);
    }

    public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,CamelScheme instance) {
        this(fluent, instance, true);
    }

    public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,CamelScheme instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConsumer(instance.getConsumer()); 
        fluent.withHttp(instance.getHttp()); 
        fluent.withId(instance.getId()); 
        fluent.withPassive(instance.getPassive()); 
        fluent.withProducer(instance.getProducer()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelSchemeBuilder(CamelScheme instance) {
        this(instance,true);
    }

    public CamelSchemeBuilder(CamelScheme instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConsumer(instance.getConsumer()); 
        this.withHttp(instance.getHttp()); 
        this.withId(instance.getId()); 
        this.withPassive(instance.getPassive()); 
        this.withProducer(instance.getProducer()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelScheme build() {
        EditableCamelScheme buildable = new EditableCamelScheme(fluent.getConsumer(),fluent.getHttp(),fluent.getId(),fluent.getPassive(),fluent.getProducer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelSchemeBuilder that = (CamelSchemeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
