package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CamelLoaderFluent<A extends CamelLoaderFluent<A>> extends Fluent<A> {


    public String getArtifactId();
    public A withArtifactId(String artifactId);
    public Boolean hasArtifactId();
    public A withNewArtifactId(StringBuilder arg1);
    public A withNewArtifactId(int[] arg1,int arg2,int arg3);
    public A withNewArtifactId(char[] arg1);
    public A withNewArtifactId(StringBuffer arg1);
    public A withNewArtifactId(byte[] arg1,int arg2);
    public A withNewArtifactId(byte[] arg1);
    public A withNewArtifactId(char[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewArtifactId(String arg1);
    public A addToDependencies(int index,MavenArtifact item);
    public A setToDependencies(int index,MavenArtifact item);
    public A addToDependencies(MavenArtifact... items);
    public A addAllToDependencies(Collection<MavenArtifact> items);
    public A removeFromDependencies(MavenArtifact... items);
    public A removeAllFromDependencies(Collection<MavenArtifact> items);
    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<MavenArtifact> getDependencies();
    public List<MavenArtifact> buildDependencies();
    public MavenArtifact buildDependency(int index);
    public MavenArtifact buildFirstDependency();
    public MavenArtifact buildLastDependency();
    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public A withDependencies(List<MavenArtifact> dependencies);
    public A withDependencies(MavenArtifact... dependencies);
    public Boolean hasDependencies();
    public A addNewDependency(String artifactId,String groupId,String version);
    public CamelLoaderFluent.DependenciesNested<A> addNewDependency();
    public CamelLoaderFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item);
    public CamelLoaderFluent.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item);
    public CamelLoaderFluent.DependenciesNested<A> editDependency(int index);
    public CamelLoaderFluent.DependenciesNested<A> editFirstDependency();
    public CamelLoaderFluent.DependenciesNested<A> editLastDependency();
    public CamelLoaderFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
    public String getGroupId();
    public A withGroupId(String groupId);
    public Boolean hasGroupId();
    public A withNewGroupId(StringBuilder arg1);
    public A withNewGroupId(int[] arg1,int arg2,int arg3);
    public A withNewGroupId(char[] arg1);
    public A withNewGroupId(StringBuffer arg1);
    public A withNewGroupId(byte[] arg1,int arg2);
    public A withNewGroupId(byte[] arg1);
    public A withNewGroupId(char[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGroupId(String arg1);
    public A addToLanguages(int index,String item);
    public A setToLanguages(int index,String item);
    public A addToLanguages(String... items);
    public A addAllToLanguages(Collection<String> items);
    public A removeFromLanguages(String... items);
    public A removeAllFromLanguages(Collection<String> items);
    public List<String> getLanguages();
    public String getLanguage(int index);
    public String getFirstLanguage();
    public String getLastLanguage();
    public String getMatchingLanguage(Predicate<String> predicate);
    public Boolean hasMatchingLanguage(Predicate<String> predicate);
    public A withLanguages(List<String> languages);
    public A withLanguages(String... languages);
    public Boolean hasLanguages();
    public A addNewLanguage(StringBuilder arg1);
    public A addNewLanguage(int[] arg1,int arg2,int arg3);
    public A addNewLanguage(char[] arg1);
    public A addNewLanguage(StringBuffer arg1);
    public A addNewLanguage(byte[] arg1,int arg2);
    public A addNewLanguage(byte[] arg1);
    public A addNewLanguage(char[] arg1,int arg2,int arg3);
    public A addNewLanguage(byte[] arg1,int arg2,int arg3);
    public A addNewLanguage(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewLanguage(String arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface DependenciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MavenArtifactFluent<CamelLoaderFluent.DependenciesNested<N>> {

            public N and();
            public N endDependency();    }


}
