package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelLoaderBuilder extends CamelLoaderFluentImpl<CamelLoaderBuilder> implements VisitableBuilder<CamelLoader,CamelLoaderBuilder> {

    CamelLoaderFluent<?> fluent;
    Boolean validationEnabled;

    public CamelLoaderBuilder() {
        this(true);
    }

    public CamelLoaderBuilder(Boolean validationEnabled) {
        this(new CamelLoader(), validationEnabled);
    }

    public CamelLoaderBuilder(CamelLoaderFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelLoaderBuilder(CamelLoaderFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelLoader(), validationEnabled);
    }

    public CamelLoaderBuilder(CamelLoaderFluent<?> fluent,CamelLoader instance) {
        this(fluent, instance, true);
    }

    public CamelLoaderBuilder(CamelLoaderFluent<?> fluent,CamelLoader instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withGroupId(instance.getGroupId()); 
        fluent.withLanguages(instance.getLanguages()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelLoaderBuilder(CamelLoader instance) {
        this(instance,true);
    }

    public CamelLoaderBuilder(CamelLoader instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withDependencies(instance.getDependencies()); 
        this.withGroupId(instance.getGroupId()); 
        this.withLanguages(instance.getLanguages()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelLoader build() {
        EditableCamelLoader buildable = new EditableCamelLoader(fluent.getArtifactId(),fluent.getDependencies(),fluent.getGroupId(),fluent.getLanguages(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelLoaderBuilder that = (CamelLoaderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
