package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelCatalogSpecBuilder extends CamelCatalogSpecFluentImpl<CamelCatalogSpecBuilder> implements VisitableBuilder<CamelCatalogSpec,CamelCatalogSpecBuilder> {

    CamelCatalogSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CamelCatalogSpecBuilder() {
        this(true);
    }

    public CamelCatalogSpecBuilder(Boolean validationEnabled) {
        this(new CamelCatalogSpec(), validationEnabled);
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelCatalogSpec(), validationEnabled);
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,CamelCatalogSpec instance) {
        this(fluent, instance, true);
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,CamelCatalogSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifacts(instance.getArtifacts()); 
        fluent.withLoaders(instance.getLoaders()); 
        fluent.withRuntime(instance.getRuntime()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpec instance) {
        this(instance,true);
    }

    public CamelCatalogSpecBuilder(CamelCatalogSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifacts(instance.getArtifacts()); 
        this.withLoaders(instance.getLoaders()); 
        this.withRuntime(instance.getRuntime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelCatalogSpec build() {
        EditableCamelCatalogSpec buildable = new EditableCamelCatalogSpec(fluent.getArtifacts(),fluent.getLoaders(),fluent.getRuntime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelCatalogSpecBuilder that = (CamelCatalogSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
