package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CamelCatalogListFluent<A extends CamelCatalogListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,CamelCatalog item);
    public A setToItems(int index,CamelCatalog item);
    public A addToItems(CamelCatalog... items);
    public A addAllToItems(Collection<CamelCatalog> items);
    public A removeFromItems(CamelCatalog... items);
    public A removeAllFromItems(Collection<CamelCatalog> items);
    public A removeMatchingFromItems(Predicate<CamelCatalogBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelCatalog> getItems();
    public List<CamelCatalog> buildItems();
    public CamelCatalog buildItem(int index);
    public CamelCatalog buildFirstItem();
    public CamelCatalog buildLastItem();
    public CamelCatalog buildMatchingItem(Predicate<CamelCatalogBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<CamelCatalogBuilder> predicate);
    public A withItems(List<CamelCatalog> items);
    public A withItems(CamelCatalog... items);
    public Boolean hasItems();
    public CamelCatalogListFluent.ItemsNested<A> addNewItem();
    public CamelCatalogListFluent.ItemsNested<A> addNewItemLike(CamelCatalog item);
    public CamelCatalogListFluent.ItemsNested<A> setNewItemLike(int index,CamelCatalog item);
    public CamelCatalogListFluent.ItemsNested<A> editItem(int index);
    public CamelCatalogListFluent.ItemsNested<A> editFirstItem();
    public CamelCatalogListFluent.ItemsNested<A> editLastItem();
    public CamelCatalogListFluent.ItemsNested<A> editMatchingItem(Predicate<CamelCatalogBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelCatalogFluent<CamelCatalogListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
