package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelArtifactBuilder extends CamelArtifactFluentImpl<CamelArtifactBuilder> implements VisitableBuilder<CamelArtifact,CamelArtifactBuilder> {

    CamelArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public CamelArtifactBuilder() {
        this(true);
    }

    public CamelArtifactBuilder(Boolean validationEnabled) {
        this(new CamelArtifact(), validationEnabled);
    }

    public CamelArtifactBuilder(CamelArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelArtifact(), validationEnabled);
    }

    public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,CamelArtifact instance) {
        this(fluent, instance, true);
    }

    public CamelArtifactBuilder(CamelArtifactFluent<?> fluent,CamelArtifact instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withDataformats(instance.getDataformats()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withExclusions(instance.getExclusions()); 
        fluent.withGroupId(instance.getGroupId()); 
        fluent.withJavaTypes(instance.getJavaTypes()); 
        fluent.withLanguages(instance.getLanguages()); 
        fluent.withSchemes(instance.getSchemes()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelArtifactBuilder(CamelArtifact instance) {
        this(instance,true);
    }

    public CamelArtifactBuilder(CamelArtifact instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withDataformats(instance.getDataformats()); 
        this.withDependencies(instance.getDependencies()); 
        this.withExclusions(instance.getExclusions()); 
        this.withGroupId(instance.getGroupId()); 
        this.withJavaTypes(instance.getJavaTypes()); 
        this.withLanguages(instance.getLanguages()); 
        this.withSchemes(instance.getSchemes()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelArtifact build() {
        EditableCamelArtifact buildable = new EditableCamelArtifact(fluent.getArtifactId(),fluent.getDataformats(),fluent.getDependencies(),fluent.getExclusions(),fluent.getGroupId(),fluent.getJavaTypes(),fluent.getLanguages(),fluent.getSchemes(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelArtifactBuilder that = (CamelArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
