package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildConditionBuilder extends BuildConditionFluentImpl<BuildConditionBuilder> implements VisitableBuilder<BuildCondition,BuildConditionBuilder> {

    BuildConditionFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConditionBuilder() {
        this(true);
    }

    public BuildConditionBuilder(Boolean validationEnabled) {
        this(new BuildCondition(), validationEnabled);
    }

    public BuildConditionBuilder(BuildConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConditionBuilder(BuildConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuildCondition(), validationEnabled);
    }

    public BuildConditionBuilder(BuildConditionFluent<?> fluent,BuildCondition instance) {
        this(fluent, instance, true);
    }

    public BuildConditionBuilder(BuildConditionFluent<?> fluent,BuildCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildConditionBuilder(BuildCondition instance) {
        this(instance,true);
    }

    public BuildConditionBuilder(BuildCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableBuildCondition build() {
        EditableBuildCondition buildable = new EditableBuildCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConditionBuilder that = (BuildConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
