package io.fabric8.camelk.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ArtifactFluentImpl<A extends ArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ArtifactFluent<A> {

    private String checksum;
    private String id;
    private String location;
    private String target;

    public ArtifactFluentImpl() {
    }

    public ArtifactFluentImpl(Artifact instance) {
        this.withChecksum(instance.getChecksum()); 
        this.withId(instance.getId()); 
        this.withLocation(instance.getLocation()); 
        this.withTarget(instance.getTarget()); 
    }

    public String getChecksum() {
        return this.checksum;
    }

    public A withChecksum(String checksum) {
        this.checksum=checksum; return (A) this;
    }

    public Boolean hasChecksum() {
        return this.checksum != null;
    }

    public A withNewChecksum(StringBuilder arg1) {
        return (A)withChecksum(new String(arg1));
    }

    public A withNewChecksum(int[] arg1,int arg2,int arg3) {
        return (A)withChecksum(new String(arg1, arg2, arg3));
    }

    public A withNewChecksum(char[] arg1) {
        return (A)withChecksum(new String(arg1));
    }

    public A withNewChecksum(StringBuffer arg1) {
        return (A)withChecksum(new String(arg1));
    }

    public A withNewChecksum(byte[] arg1,int arg2) {
        return (A)withChecksum(new String(arg1, arg2));
    }

    public A withNewChecksum(byte[] arg1) {
        return (A)withChecksum(new String(arg1));
    }

    public A withNewChecksum(char[] arg1,int arg2,int arg3) {
        return (A)withChecksum(new String(arg1, arg2, arg3));
    }

    public A withNewChecksum(byte[] arg1,int arg2,int arg3) {
        return (A)withChecksum(new String(arg1, arg2, arg3));
    }

    public A withNewChecksum(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withChecksum(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewChecksum(String arg1) {
        return (A)withChecksum(new String(arg1));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id=id; return (A) this;
    }

    public Boolean hasId() {
        return this.id != null;
    }

    public A withNewId(StringBuilder arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(int[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(char[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuffer arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(byte[] arg1,int arg2) {
        return (A)withId(new String(arg1, arg2));
    }

    public A withNewId(byte[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(char[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewId(String arg1) {
        return (A)withId(new String(arg1));
    }

    public String getLocation() {
        return this.location;
    }

    public A withLocation(String location) {
        this.location=location; return (A) this;
    }

    public Boolean hasLocation() {
        return this.location != null;
    }

    public A withNewLocation(StringBuilder arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(int[] arg1,int arg2,int arg3) {
        return (A)withLocation(new String(arg1, arg2, arg3));
    }

    public A withNewLocation(char[] arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuffer arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(byte[] arg1,int arg2) {
        return (A)withLocation(new String(arg1, arg2));
    }

    public A withNewLocation(byte[] arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(char[] arg1,int arg2,int arg3) {
        return (A)withLocation(new String(arg1, arg2, arg3));
    }

    public A withNewLocation(byte[] arg1,int arg2,int arg3) {
        return (A)withLocation(new String(arg1, arg2, arg3));
    }

    public A withNewLocation(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLocation(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLocation(String arg1) {
        return (A)withLocation(new String(arg1));
    }

    public String getTarget() {
        return this.target;
    }

    public A withTarget(String target) {
        this.target=target; return (A) this;
    }

    public Boolean hasTarget() {
        return this.target != null;
    }

    public A withNewTarget(StringBuilder arg1) {
        return (A)withTarget(new String(arg1));
    }

    public A withNewTarget(int[] arg1,int arg2,int arg3) {
        return (A)withTarget(new String(arg1, arg2, arg3));
    }

    public A withNewTarget(char[] arg1) {
        return (A)withTarget(new String(arg1));
    }

    public A withNewTarget(StringBuffer arg1) {
        return (A)withTarget(new String(arg1));
    }

    public A withNewTarget(byte[] arg1,int arg2) {
        return (A)withTarget(new String(arg1, arg2));
    }

    public A withNewTarget(byte[] arg1) {
        return (A)withTarget(new String(arg1));
    }

    public A withNewTarget(char[] arg1,int arg2,int arg3) {
        return (A)withTarget(new String(arg1, arg2, arg3));
    }

    public A withNewTarget(byte[] arg1,int arg2,int arg3) {
        return (A)withTarget(new String(arg1, arg2, arg3));
    }

    public A withNewTarget(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTarget(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTarget(String arg1) {
        return (A)withTarget(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ArtifactFluentImpl that = (ArtifactFluentImpl) o;
        if (checksum != null ? !checksum.equals(that.checksum) :that.checksum != null) return false;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        if (location != null ? !location.equals(that.location) :that.location != null) return false;
        if (target != null ? !target.equals(that.target) :that.target != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(checksum,  id,  location,  target,  super.hashCode());
    }

}
