package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ArtifactBuilder extends ArtifactFluentImpl<ArtifactBuilder> implements VisitableBuilder<Artifact,ArtifactBuilder> {

    ArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public ArtifactBuilder() {
        this(true);
    }

    public ArtifactBuilder(Boolean validationEnabled) {
        this(new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent,Artifact instance) {
        this(fluent, instance, true);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent,Artifact instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChecksum(instance.getChecksum()); 
        fluent.withId(instance.getId()); 
        fluent.withLocation(instance.getLocation()); 
        fluent.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public ArtifactBuilder(Artifact instance) {
        this(instance,true);
    }

    public ArtifactBuilder(Artifact instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withChecksum(instance.getChecksum()); 
        this.withId(instance.getId()); 
        this.withLocation(instance.getLocation()); 
        this.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableArtifact build() {
        EditableArtifact buildable = new EditableArtifact(fluent.getChecksum(),fluent.getId(),fluent.getLocation(),fluent.getTarget());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ArtifactBuilder that = (ArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
