package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

public interface ValueSourceFluent<A extends ValueSourceFluent<A>> extends Fluent<A> {


    public ConfigMapKeySelector getConfigMapKeyRef();
    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef);
    public Boolean hasConfigMapKeyRef();
    public A withNewConfigMapKeyRef(String key,String name,Boolean optional);
    public SecretKeySelector getSecretKeyRef();
    public A withSecretKeyRef(SecretKeySelector secretKeyRef);
    public Boolean hasSecretKeyRef();
    public A withNewSecretKeyRef(String key,String name,Boolean optional);
}
