package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraitSpecBuilder extends TraitSpecFluentImpl<TraitSpecBuilder> implements VisitableBuilder<TraitSpec,TraitSpecBuilder> {

    TraitSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TraitSpecBuilder() {
        this(true);
    }

    public TraitSpecBuilder(Boolean validationEnabled) {
        this(new TraitSpec(), validationEnabled);
    }

    public TraitSpecBuilder(TraitSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TraitSpecBuilder(TraitSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TraitSpec(), validationEnabled);
    }

    public TraitSpecBuilder(TraitSpecFluent<?> fluent,TraitSpec instance) {
        this(fluent, instance, true);
    }

    public TraitSpecBuilder(TraitSpecFluent<?> fluent,TraitSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfiguration(instance.getConfiguration()); 
        this.validationEnabled = validationEnabled; 
    }

    public TraitSpecBuilder(TraitSpec instance) {
        this(instance,true);
    }

    public TraitSpecBuilder(TraitSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfiguration(instance.getConfiguration()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableTraitSpec build() {
        EditableTraitSpec buildable = new EditableTraitSpec(fluent.getConfiguration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TraitSpecBuilder that = (TraitSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
