package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SourceSpecFluentImpl<A extends SourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SourceSpecFluent<A> {

    private Boolean compression;
    private String content;
    private String contentKey;
    private String contentRef;
    private List<String> interceptors;
    private String language;
    private String loader;
    private String name;
    private List<String> propertyNames;
    private String type;

    public SourceSpecFluentImpl() {
    }

    public SourceSpecFluentImpl(SourceSpec instance) {
        this.withCompression(instance.getCompression()); 
        this.withContent(instance.getContent()); 
        this.withContentKey(instance.getContentKey()); 
        this.withContentRef(instance.getContentRef()); 
        this.withInterceptors(instance.getInterceptors()); 
        this.withLanguage(instance.getLanguage()); 
        this.withLoader(instance.getLoader()); 
        this.withName(instance.getName()); 
        this.withPropertyNames(instance.getPropertyNames()); 
        this.withType(instance.getType()); 
    }

    public Boolean getCompression() {
        return this.compression;
    }

    public A withCompression(Boolean compression) {
        this.compression=compression; return (A) this;
    }

    public Boolean hasCompression() {
        return this.compression != null;
    }

    public A withNewCompression(String arg1) {
        return (A)withCompression(new Boolean(arg1));
    }

    public A withNewCompression(boolean arg1) {
        return (A)withCompression(new Boolean(arg1));
    }

    public String getContent() {
        return this.content;
    }

    public A withContent(String content) {
        this.content=content; return (A) this;
    }

    public Boolean hasContent() {
        return this.content != null;
    }

    public A withNewContent(StringBuilder arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(int[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(char[] arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(StringBuffer arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(byte[] arg1,int arg2) {
        return (A)withContent(new String(arg1, arg2));
    }

    public A withNewContent(byte[] arg1) {
        return (A)withContent(new String(arg1));
    }

    public A withNewContent(char[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(byte[] arg1,int arg2,int arg3) {
        return (A)withContent(new String(arg1, arg2, arg3));
    }

    public A withNewContent(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContent(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContent(String arg1) {
        return (A)withContent(new String(arg1));
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public A withContentKey(String contentKey) {
        this.contentKey=contentKey; return (A) this;
    }

    public Boolean hasContentKey() {
        return this.contentKey != null;
    }

    public A withNewContentKey(StringBuilder arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(int[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(char[] arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(StringBuffer arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(byte[] arg1,int arg2) {
        return (A)withContentKey(new String(arg1, arg2));
    }

    public A withNewContentKey(byte[] arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public A withNewContentKey(char[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(byte[] arg1,int arg2,int arg3) {
        return (A)withContentKey(new String(arg1, arg2, arg3));
    }

    public A withNewContentKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContentKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContentKey(String arg1) {
        return (A)withContentKey(new String(arg1));
    }

    public String getContentRef() {
        return this.contentRef;
    }

    public A withContentRef(String contentRef) {
        this.contentRef=contentRef; return (A) this;
    }

    public Boolean hasContentRef() {
        return this.contentRef != null;
    }

    public A withNewContentRef(StringBuilder arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(int[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(char[] arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(StringBuffer arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(byte[] arg1,int arg2) {
        return (A)withContentRef(new String(arg1, arg2));
    }

    public A withNewContentRef(byte[] arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A withNewContentRef(char[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(byte[] arg1,int arg2,int arg3) {
        return (A)withContentRef(new String(arg1, arg2, arg3));
    }

    public A withNewContentRef(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withContentRef(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewContentRef(String arg1) {
        return (A)withContentRef(new String(arg1));
    }

    public A addToInterceptors(int index,String item) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
        this.interceptors.add(index, item);
        return (A)this;
    }

    public A setToInterceptors(int index,String item) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
        this.interceptors.set(index, item); return (A)this;
    }

    public A addToInterceptors(String... items) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
        for (String item : items) {this.interceptors.add(item);} return (A)this;
    }

    public A addAllToInterceptors(Collection<String> items) {
        if (this.interceptors == null) {this.interceptors = new ArrayList<String>();}
        for (String item : items) {this.interceptors.add(item);} return (A)this;
    }

    public A removeFromInterceptors(String... items) {
        for (String item : items) {if (this.interceptors!= null){ this.interceptors.remove(item);}} return (A)this;
    }

    public A removeAllFromInterceptors(Collection<String> items) {
        for (String item : items) {if (this.interceptors!= null){ this.interceptors.remove(item);}} return (A)this;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public String getInterceptor(int index) {
        return this.interceptors.get(index);
    }

    public String getFirstInterceptor() {
        return this.interceptors.get(0);
    }

    public String getLastInterceptor() {
        return this.interceptors.get(interceptors.size() - 1);
    }

    public String getMatchingInterceptor(Predicate<String> predicate) {
        for (String item: interceptors) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingInterceptor(Predicate<String> predicate) {
        for (String item: interceptors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withInterceptors(List<String> interceptors) {
        if (this.interceptors != null) { _visitables.get("interceptors").removeAll(this.interceptors);}
        if (interceptors != null) {this.interceptors = new ArrayList<String>(); for (String item : interceptors){this.addToInterceptors(item);}} else { this.interceptors = null;} return (A) this;
    }

    public A withInterceptors(String... interceptors) {
        if (this.interceptors != null) {this.interceptors.clear();}
        if (interceptors != null) {for (String item :interceptors){ this.addToInterceptors(item);}} return (A) this;
    }

    public Boolean hasInterceptors() {
        return interceptors != null && !interceptors.isEmpty();
    }

    public A addNewInterceptor(StringBuilder arg1) {
        return (A)addToInterceptors(new String(arg1));
    }

    public A addNewInterceptor(int[] arg1,int arg2,int arg3) {
        return (A)addToInterceptors(new String(arg1, arg2, arg3));
    }

    public A addNewInterceptor(char[] arg1) {
        return (A)addToInterceptors(new String(arg1));
    }

    public A addNewInterceptor(StringBuffer arg1) {
        return (A)addToInterceptors(new String(arg1));
    }

    public A addNewInterceptor(byte[] arg1,int arg2) {
        return (A)addToInterceptors(new String(arg1, arg2));
    }

    public A addNewInterceptor(byte[] arg1) {
        return (A)addToInterceptors(new String(arg1));
    }

    public A addNewInterceptor(char[] arg1,int arg2,int arg3) {
        return (A)addToInterceptors(new String(arg1, arg2, arg3));
    }

    public A addNewInterceptor(byte[] arg1,int arg2,int arg3) {
        return (A)addToInterceptors(new String(arg1, arg2, arg3));
    }

    public A addNewInterceptor(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToInterceptors(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewInterceptor(String arg1) {
        return (A)addToInterceptors(new String(arg1));
    }

    public String getLanguage() {
        return this.language;
    }

    public A withLanguage(String language) {
        this.language=language; return (A) this;
    }

    public Boolean hasLanguage() {
        return this.language != null;
    }

    public A withNewLanguage(StringBuilder arg1) {
        return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(int[] arg1,int arg2,int arg3) {
        return (A)withLanguage(new String(arg1, arg2, arg3));
    }

    public A withNewLanguage(char[] arg1) {
        return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(StringBuffer arg1) {
        return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(byte[] arg1,int arg2) {
        return (A)withLanguage(new String(arg1, arg2));
    }

    public A withNewLanguage(byte[] arg1) {
        return (A)withLanguage(new String(arg1));
    }

    public A withNewLanguage(char[] arg1,int arg2,int arg3) {
        return (A)withLanguage(new String(arg1, arg2, arg3));
    }

    public A withNewLanguage(byte[] arg1,int arg2,int arg3) {
        return (A)withLanguage(new String(arg1, arg2, arg3));
    }

    public A withNewLanguage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLanguage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLanguage(String arg1) {
        return (A)withLanguage(new String(arg1));
    }

    public String getLoader() {
        return this.loader;
    }

    public A withLoader(String loader) {
        this.loader=loader; return (A) this;
    }

    public Boolean hasLoader() {
        return this.loader != null;
    }

    public A withNewLoader(StringBuilder arg1) {
        return (A)withLoader(new String(arg1));
    }

    public A withNewLoader(int[] arg1,int arg2,int arg3) {
        return (A)withLoader(new String(arg1, arg2, arg3));
    }

    public A withNewLoader(char[] arg1) {
        return (A)withLoader(new String(arg1));
    }

    public A withNewLoader(StringBuffer arg1) {
        return (A)withLoader(new String(arg1));
    }

    public A withNewLoader(byte[] arg1,int arg2) {
        return (A)withLoader(new String(arg1, arg2));
    }

    public A withNewLoader(byte[] arg1) {
        return (A)withLoader(new String(arg1));
    }

    public A withNewLoader(char[] arg1,int arg2,int arg3) {
        return (A)withLoader(new String(arg1, arg2, arg3));
    }

    public A withNewLoader(byte[] arg1,int arg2,int arg3) {
        return (A)withLoader(new String(arg1, arg2, arg3));
    }

    public A withNewLoader(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLoader(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLoader(String arg1) {
        return (A)withLoader(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A addToPropertyNames(int index,String item) {
        if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
        this.propertyNames.add(index, item);
        return (A)this;
    }

    public A setToPropertyNames(int index,String item) {
        if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
        this.propertyNames.set(index, item); return (A)this;
    }

    public A addToPropertyNames(String... items) {
        if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
        for (String item : items) {this.propertyNames.add(item);} return (A)this;
    }

    public A addAllToPropertyNames(Collection<String> items) {
        if (this.propertyNames == null) {this.propertyNames = new ArrayList<String>();}
        for (String item : items) {this.propertyNames.add(item);} return (A)this;
    }

    public A removeFromPropertyNames(String... items) {
        for (String item : items) {if (this.propertyNames!= null){ this.propertyNames.remove(item);}} return (A)this;
    }

    public A removeAllFromPropertyNames(Collection<String> items) {
        for (String item : items) {if (this.propertyNames!= null){ this.propertyNames.remove(item);}} return (A)this;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public String getPropertyName(int index) {
        return this.propertyNames.get(index);
    }

    public String getFirstPropertyName() {
        return this.propertyNames.get(0);
    }

    public String getLastPropertyName() {
        return this.propertyNames.get(propertyNames.size() - 1);
    }

    public String getMatchingPropertyName(Predicate<String> predicate) {
        for (String item: propertyNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPropertyName(Predicate<String> predicate) {
        for (String item: propertyNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPropertyNames(List<String> propertyNames) {
        if (this.propertyNames != null) { _visitables.get("propertyNames").removeAll(this.propertyNames);}
        if (propertyNames != null) {this.propertyNames = new ArrayList<String>(); for (String item : propertyNames){this.addToPropertyNames(item);}} else { this.propertyNames = null;} return (A) this;
    }

    public A withPropertyNames(String... propertyNames) {
        if (this.propertyNames != null) {this.propertyNames.clear();}
        if (propertyNames != null) {for (String item :propertyNames){ this.addToPropertyNames(item);}} return (A) this;
    }

    public Boolean hasPropertyNames() {
        return propertyNames != null && !propertyNames.isEmpty();
    }

    public A addNewPropertyName(StringBuilder arg1) {
        return (A)addToPropertyNames(new String(arg1));
    }

    public A addNewPropertyName(int[] arg1,int arg2,int arg3) {
        return (A)addToPropertyNames(new String(arg1, arg2, arg3));
    }

    public A addNewPropertyName(char[] arg1) {
        return (A)addToPropertyNames(new String(arg1));
    }

    public A addNewPropertyName(StringBuffer arg1) {
        return (A)addToPropertyNames(new String(arg1));
    }

    public A addNewPropertyName(byte[] arg1,int arg2) {
        return (A)addToPropertyNames(new String(arg1, arg2));
    }

    public A addNewPropertyName(byte[] arg1) {
        return (A)addToPropertyNames(new String(arg1));
    }

    public A addNewPropertyName(char[] arg1,int arg2,int arg3) {
        return (A)addToPropertyNames(new String(arg1, arg2, arg3));
    }

    public A addNewPropertyName(byte[] arg1,int arg2,int arg3) {
        return (A)addToPropertyNames(new String(arg1, arg2, arg3));
    }

    public A addNewPropertyName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToPropertyNames(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewPropertyName(String arg1) {
        return (A)addToPropertyNames(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SourceSpecFluentImpl that = (SourceSpecFluentImpl) o;
        if (compression != null ? !compression.equals(that.compression) :that.compression != null) return false;
        if (content != null ? !content.equals(that.content) :that.content != null) return false;
        if (contentKey != null ? !contentKey.equals(that.contentKey) :that.contentKey != null) return false;
        if (contentRef != null ? !contentRef.equals(that.contentRef) :that.contentRef != null) return false;
        if (interceptors != null ? !interceptors.equals(that.interceptors) :that.interceptors != null) return false;
        if (language != null ? !language.equals(that.language) :that.language != null) return false;
        if (loader != null ? !loader.equals(that.loader) :that.loader != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (propertyNames != null ? !propertyNames.equals(that.propertyNames) :that.propertyNames != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(compression,  content,  contentKey,  contentRef,  interceptors,  language,  loader,  name,  propertyNames,  type,  super.hashCode());
    }

}
