package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class MavenSpecFluentImpl<A extends MavenSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MavenSpecFluent<A> {

    private String localRepository;
    private ValueSourceBuilder settings;
    private Duration timeout;

    public MavenSpecFluentImpl() {
    }

    public MavenSpecFluentImpl(MavenSpec instance) {
        this.withLocalRepository(instance.getLocalRepository()); 
        this.withSettings(instance.getSettings()); 
        this.withTimeout(instance.getTimeout()); 
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public A withLocalRepository(String localRepository) {
        this.localRepository=localRepository; return (A) this;
    }

    public Boolean hasLocalRepository() {
        return this.localRepository != null;
    }

    public A withNewLocalRepository(StringBuilder arg1) {
        return (A)withLocalRepository(new String(arg1));
    }

    public A withNewLocalRepository(int[] arg1,int arg2,int arg3) {
        return (A)withLocalRepository(new String(arg1, arg2, arg3));
    }

    public A withNewLocalRepository(char[] arg1) {
        return (A)withLocalRepository(new String(arg1));
    }

    public A withNewLocalRepository(StringBuffer arg1) {
        return (A)withLocalRepository(new String(arg1));
    }

    public A withNewLocalRepository(byte[] arg1,int arg2) {
        return (A)withLocalRepository(new String(arg1, arg2));
    }

    public A withNewLocalRepository(byte[] arg1) {
        return (A)withLocalRepository(new String(arg1));
    }

    public A withNewLocalRepository(char[] arg1,int arg2,int arg3) {
        return (A)withLocalRepository(new String(arg1, arg2, arg3));
    }

    public A withNewLocalRepository(byte[] arg1,int arg2,int arg3) {
        return (A)withLocalRepository(new String(arg1, arg2, arg3));
    }

    public A withNewLocalRepository(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLocalRepository(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLocalRepository(String arg1) {
        return (A)withLocalRepository(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSettings instead.
 * @return The buildable object.
 */
@Deprecated public ValueSource getSettings() {
        return this.settings!=null?this.settings.build():null;
    }

    public ValueSource buildSettings() {
        return this.settings!=null?this.settings.build():null;
    }

    public A withSettings(ValueSource settings) {
        _visitables.get("settings").remove(this.settings);
        if (settings!=null){ this.settings= new ValueSourceBuilder(settings); _visitables.get("settings").add(this.settings);} return (A) this;
    }

    public Boolean hasSettings() {
        return this.settings != null;
    }

    public MavenSpecFluent.SettingsNested<A> withNewSettings() {
        return new SettingsNestedImpl();
    }

    public MavenSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item) {
        return new SettingsNestedImpl(item);
    }

    public MavenSpecFluent.SettingsNested<A> editSettings() {
        return withNewSettingsLike(getSettings());
    }

    public MavenSpecFluent.SettingsNested<A> editOrNewSettings() {
        return withNewSettingsLike(getSettings() != null ? getSettings(): new ValueSourceBuilder().build());
    }

    public MavenSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item) {
        return withNewSettingsLike(getSettings() != null ? getSettings(): item);
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MavenSpecFluentImpl that = (MavenSpecFluentImpl) o;
        if (localRepository != null ? !localRepository.equals(that.localRepository) :that.localRepository != null) return false;
        if (settings != null ? !settings.equals(that.settings) :that.settings != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(localRepository,  settings,  timeout,  super.hashCode());
    }

    public class SettingsNestedImpl<N> extends ValueSourceFluentImpl<MavenSpecFluent.SettingsNested<N>> implements MavenSpecFluent.SettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ValueSourceBuilder builder;

            SettingsNestedImpl(ValueSource item) {
                this.builder = new ValueSourceBuilder(this, item);
                        
            }

            SettingsNestedImpl() {
                this.builder = new ValueSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MavenSpecFluentImpl.this.withSettings(builder.build());
            }

            public N endSettings() {
                return and();
            }
    }


}
