package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MavenArtifactBuilder extends MavenArtifactFluentImpl<MavenArtifactBuilder> implements VisitableBuilder<MavenArtifact,MavenArtifactBuilder> {

    MavenArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public MavenArtifactBuilder() {
        this(true);
    }

    public MavenArtifactBuilder(Boolean validationEnabled) {
        this(new MavenArtifact(), validationEnabled);
    }

    public MavenArtifactBuilder(MavenArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MavenArtifact(), validationEnabled);
    }

    public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,MavenArtifact instance) {
        this(fluent, instance, true);
    }

    public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,MavenArtifact instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withGroupId(instance.getGroupId()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public MavenArtifactBuilder(MavenArtifact instance) {
        this(instance,true);
    }

    public MavenArtifactBuilder(MavenArtifact instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withGroupId(instance.getGroupId()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableMavenArtifact build() {
        EditableMavenArtifact buildable = new EditableMavenArtifact(fluent.getArtifactId(),fluent.getGroupId(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MavenArtifactBuilder that = (MavenArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
