package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class IntegrationPlatformStatusFluentImpl<A extends IntegrationPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IntegrationPlatformStatusFluent<A> {

    private IntegrationPlatformBuildSpecBuilder build;
    private String cluster;
    private List<IntegrationPlatformConditionBuilder> conditions;
    private List<ConfigurationSpecBuilder> configuration;
    private IntegrationPlatformKameletSpecBuilder kamelet;
    private String phase;
    private String profile;
    private IntegrationPlatformResourcesSpecBuilder resources;
    private Map<String,TraitSpec> traits;
    private String version;

    public IntegrationPlatformStatusFluentImpl() {
    }

    public IntegrationPlatformStatusFluentImpl(IntegrationPlatformStatus instance) {
        this.withBuild(instance.getBuild()); 
        this.withCluster(instance.getCluster()); 
        this.withConditions(instance.getConditions()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withKamelet(instance.getKamelet()); 
        this.withPhase(instance.getPhase()); 
        this.withProfile(instance.getProfile()); 
        this.withResources(instance.getResources()); 
        this.withTraits(instance.getTraits()); 
        this.withVersion(instance.getVersion()); 
    }

    
/**
 * This method has been deprecated, please use method buildBuild instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformBuildSpec getBuild() {
        return this.build!=null?this.build.build():null;
    }

    public IntegrationPlatformBuildSpec buildBuild() {
        return this.build!=null?this.build.build():null;
    }

    public A withBuild(IntegrationPlatformBuildSpec build) {
        _visitables.get("build").remove(this.build);
        if (build!=null){ this.build= new IntegrationPlatformBuildSpecBuilder(build); _visitables.get("build").add(this.build);} return (A) this;
    }

    public Boolean hasBuild() {
        return this.build != null;
    }

    public IntegrationPlatformStatusFluent.BuildNested<A> withNewBuild() {
        return new BuildNestedImpl();
    }

    public IntegrationPlatformStatusFluent.BuildNested<A> withNewBuildLike(IntegrationPlatformBuildSpec item) {
        return new BuildNestedImpl(item);
    }

    public IntegrationPlatformStatusFluent.BuildNested<A> editBuild() {
        return withNewBuildLike(getBuild());
    }

    public IntegrationPlatformStatusFluent.BuildNested<A> editOrNewBuild() {
        return withNewBuildLike(getBuild() != null ? getBuild(): new IntegrationPlatformBuildSpecBuilder().build());
    }

    public IntegrationPlatformStatusFluent.BuildNested<A> editOrNewBuildLike(IntegrationPlatformBuildSpec item) {
        return withNewBuildLike(getBuild() != null ? getBuild(): item);
    }

    public String getCluster() {
        return this.cluster;
    }

    public A withCluster(String cluster) {
        this.cluster=cluster; return (A) this;
    }

    public Boolean hasCluster() {
        return this.cluster != null;
    }

    public A withNewCluster(StringBuilder arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(int[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(char[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(StringBuffer arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(byte[] arg1,int arg2) {
        return (A)withCluster(new String(arg1, arg2));
    }

    public A withNewCluster(byte[] arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A withNewCluster(char[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3) {
        return (A)withCluster(new String(arg1, arg2, arg3));
    }

    public A withNewCluster(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCluster(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCluster(String arg1) {
        return (A)withCluster(new String(arg1));
    }

    public A addToConditions(int index,IntegrationPlatformCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
        IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,IntegrationPlatformCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
        IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(IntegrationPlatformCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
        for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<IntegrationPlatformCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
        for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(IntegrationPlatformCondition... items) {
        for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<IntegrationPlatformCondition> items) {
        for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<IntegrationPlatformConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<IntegrationPlatformConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          IntegrationPlatformConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<IntegrationPlatformCondition> getConditions() {
        return build(conditions);
    }

    public List<IntegrationPlatformCondition> buildConditions() {
        return build(conditions);
    }

    public IntegrationPlatformCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public IntegrationPlatformCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public IntegrationPlatformCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public IntegrationPlatformCondition buildMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
        for (IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
        for (IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<IntegrationPlatformCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>(); for (IntegrationPlatformCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(IntegrationPlatformCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (IntegrationPlatformCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationPlatformCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> setNewConditionLike(int index,IntegrationPlatformCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public IntegrationPlatformStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(index >= 0 ? index : _visitables.get("configuration").size(), builder);this.configuration.add(index >= 0 ? index : configuration.size(), builder); return (A)this;
    }

    public A setToConfiguration(int index,ConfigurationSpec item) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("configuration").size()) { _visitables.get("configuration").add(builder); } else { _visitables.get("configuration").set(index, builder);}
        if (index < 0 || index >= configuration.size()) { configuration.add(builder); } else { configuration.set(index, builder);}
         return (A)this;
    }

    public A addToConfiguration(ConfigurationSpec... items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
    }

    public A removeFromConfiguration(ConfigurationSpec... items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (configuration == null) return (A) this;
        final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
        final List visitables = _visitables.get("configuration");
        while (each.hasNext()) {
          ConfigurationSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigurationSpec> getConfiguration() {
        return build(configuration);
    }

    public List<ConfigurationSpec> buildConfiguration() {
        return build(configuration);
    }

    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(configuration.size() - 1).build();
    }

    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) { _visitables.get("configuration").removeAll(this.configuration);}
        if (configuration != null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
    }

    public A withConfiguration(ConfigurationSpec... configuration) {
        if (this.configuration != null) {this.configuration.clear();}
        if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
    }

    public Boolean hasConfiguration() {
        return configuration != null && !configuration.isEmpty();
    }

    public A addNewConfiguration(String type,String value) {
        return (A)addToConfiguration(new ConfigurationSpec(type, value));
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
        return setNewConfigurationLike(0, buildConfiguration(0));
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = configuration.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    public IntegrationPlatformStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<configuration.size();i++) { 
        if (predicate.test(configuration.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
        return setNewConfigurationLike(index, buildConfiguration(index));
    }

    
/**
 * This method has been deprecated, please use method buildKamelet instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformKameletSpec getKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public IntegrationPlatformKameletSpec buildKamelet() {
        return this.kamelet!=null?this.kamelet.build():null;
    }

    public A withKamelet(IntegrationPlatformKameletSpec kamelet) {
        _visitables.get("kamelet").remove(this.kamelet);
        if (kamelet!=null){ this.kamelet= new IntegrationPlatformKameletSpecBuilder(kamelet); _visitables.get("kamelet").add(this.kamelet);} return (A) this;
    }

    public Boolean hasKamelet() {
        return this.kamelet != null;
    }

    public IntegrationPlatformStatusFluent.KameletNested<A> withNewKamelet() {
        return new KameletNestedImpl();
    }

    public IntegrationPlatformStatusFluent.KameletNested<A> withNewKameletLike(IntegrationPlatformKameletSpec item) {
        return new KameletNestedImpl(item);
    }

    public IntegrationPlatformStatusFluent.KameletNested<A> editKamelet() {
        return withNewKameletLike(getKamelet());
    }

    public IntegrationPlatformStatusFluent.KameletNested<A> editOrNewKamelet() {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): new IntegrationPlatformKameletSpecBuilder().build());
    }

    public IntegrationPlatformStatusFluent.KameletNested<A> editOrNewKameletLike(IntegrationPlatformKameletSpec item) {
        return withNewKameletLike(getKamelet() != null ? getKamelet(): item);
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile=profile; return (A) this;
    }

    public Boolean hasProfile() {
        return this.profile != null;
    }

    public A withNewProfile(StringBuilder arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(int[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(char[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(StringBuffer arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(byte[] arg1,int arg2) {
        return (A)withProfile(new String(arg1, arg2));
    }

    public A withNewProfile(byte[] arg1) {
        return (A)withProfile(new String(arg1));
    }

    public A withNewProfile(char[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3) {
        return (A)withProfile(new String(arg1, arg2, arg3));
    }

    public A withNewProfile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withProfile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewProfile(String arg1) {
        return (A)withProfile(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformResourcesSpec getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public IntegrationPlatformResourcesSpec buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(IntegrationPlatformResourcesSpec resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new IntegrationPlatformResourcesSpecBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public IntegrationPlatformStatusFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public IntegrationPlatformStatusFluent.ResourcesNested<A> withNewResourcesLike(IntegrationPlatformResourcesSpec item) {
        return new ResourcesNestedImpl(item);
    }

    public IntegrationPlatformStatusFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public IntegrationPlatformStatusFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new IntegrationPlatformResourcesSpecBuilder().build());
    }

    public IntegrationPlatformStatusFluent.ResourcesNested<A> editOrNewResourcesLike(IntegrationPlatformResourcesSpec item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public A addToTraits(String key,TraitSpec value) {
        if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
    }

    public A addToTraits(Map<String,TraitSpec> map) {
        if(this.traits == null && map != null) { this.traits = new LinkedHashMap<String,TraitSpec>(); }
        if(map != null) { this.traits.putAll(map);} return (A)this;
    }

    public A removeFromTraits(String key) {
        if(this.traits == null) { return (A) this; }
        if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
    }

    public A removeFromTraits(Map<String,TraitSpec> map) {
        if(this.traits == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
    }

    public Map<String,TraitSpec> getTraits() {
        return this.traits;
    }

    public <K extends Object,V extends Object>A withTraits(Map<String,TraitSpec> traits) {
        if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap<String,TraitSpec>(traits);} return (A) this;
    }

    public Boolean hasTraits() {
        return this.traits != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IntegrationPlatformStatusFluentImpl that = (IntegrationPlatformStatusFluentImpl) o;
        if (build != null ? !build.equals(that.build) :that.build != null) return false;
        if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (kamelet != null ? !kamelet.equals(that.kamelet) :that.kamelet != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (traits != null ? !traits.equals(that.traits) :that.traits != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(build,  cluster,  conditions,  configuration,  kamelet,  phase,  profile,  resources,  traits,  version,  super.hashCode());
    }

    public class BuildNestedImpl<N> extends IntegrationPlatformBuildSpecFluentImpl<IntegrationPlatformStatusFluent.BuildNested<N>> implements IntegrationPlatformStatusFluent.BuildNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformBuildSpecBuilder builder;

            BuildNestedImpl(IntegrationPlatformBuildSpec item) {
                this.builder = new IntegrationPlatformBuildSpecBuilder(this, item);
                        
            }

            BuildNestedImpl() {
                this.builder = new IntegrationPlatformBuildSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withBuild(builder.build());
            }

            public N endBuild() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends IntegrationPlatformConditionFluentImpl<IntegrationPlatformStatusFluent.ConditionsNested<N>> implements IntegrationPlatformStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,IntegrationPlatformCondition item) {
                this.index = index;
                this.builder = new IntegrationPlatformConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new IntegrationPlatformConditionBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationPlatformStatusFluent.ConfigurationNested<N>> implements IntegrationPlatformStatusFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigurationSpecBuilder builder;
        private final int index;

            ConfigurationNestedImpl(int index,ConfigurationSpec item) {
                this.index = index;
                this.builder = new ConfigurationSpecBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.index = -1;
                this.builder = new ConfigurationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.setToConfiguration(index,builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


    public class KameletNestedImpl<N> extends IntegrationPlatformKameletSpecFluentImpl<IntegrationPlatformStatusFluent.KameletNested<N>> implements IntegrationPlatformStatusFluent.KameletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformKameletSpecBuilder builder;

            KameletNestedImpl(IntegrationPlatformKameletSpec item) {
                this.builder = new IntegrationPlatformKameletSpecBuilder(this, item);
                        
            }

            KameletNestedImpl() {
                this.builder = new IntegrationPlatformKameletSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withKamelet(builder.build());
            }

            public N endKamelet() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends IntegrationPlatformResourcesSpecFluentImpl<IntegrationPlatformStatusFluent.ResourcesNested<N>> implements IntegrationPlatformStatusFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntegrationPlatformResourcesSpecBuilder builder;

            ResourcesNestedImpl(IntegrationPlatformResourcesSpec item) {
                this.builder = new IntegrationPlatformResourcesSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new IntegrationPlatformResourcesSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IntegrationPlatformStatusFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


}
