package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformSpecBuilder extends IntegrationPlatformSpecFluentImpl<IntegrationPlatformSpecBuilder> implements VisitableBuilder<IntegrationPlatformSpec,IntegrationPlatformSpecBuilder> {

    IntegrationPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformSpecBuilder() {
        this(true);
    }

    public IntegrationPlatformSpecBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformSpec(), validationEnabled);
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformSpec(), validationEnabled);
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,IntegrationPlatformSpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,IntegrationPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuild(instance.getBuild()); 
        fluent.withCluster(instance.getCluster()); 
        fluent.withConfiguration(instance.getConfiguration()); 
        fluent.withKamelet(instance.getKamelet()); 
        fluent.withProfile(instance.getProfile()); 
        fluent.withResources(instance.getResources()); 
        fluent.withTraits(instance.getTraits()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformSpecBuilder(IntegrationPlatformSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuild(instance.getBuild()); 
        this.withCluster(instance.getCluster()); 
        this.withConfiguration(instance.getConfiguration()); 
        this.withKamelet(instance.getKamelet()); 
        this.withProfile(instance.getProfile()); 
        this.withResources(instance.getResources()); 
        this.withTraits(instance.getTraits()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformSpec build() {
        EditableIntegrationPlatformSpec buildable = new EditableIntegrationPlatformSpec(fluent.getBuild(),fluent.getCluster(),fluent.getConfiguration(),fluent.getKamelet(),fluent.getProfile(),fluent.getResources(),fluent.getTraits());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformSpecBuilder that = (IntegrationPlatformSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
