package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformResourcesSpecBuilder extends IntegrationPlatformResourcesSpecFluentImpl<IntegrationPlatformResourcesSpecBuilder> implements VisitableBuilder<IntegrationPlatformResourcesSpec,IntegrationPlatformResourcesSpecBuilder> {

    IntegrationPlatformResourcesSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformResourcesSpecBuilder() {
        this(true);
    }

    public IntegrationPlatformResourcesSpecBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformResourcesSpec(), validationEnabled);
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformResourcesSpec(), validationEnabled);
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpecFluent<?> fluent,IntegrationPlatformResourcesSpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpecFluent<?> fluent,IntegrationPlatformResourcesSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformResourcesSpecBuilder(IntegrationPlatformResourcesSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformResourcesSpec build() {
        EditableIntegrationPlatformResourcesSpec buildable = new EditableIntegrationPlatformResourcesSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformResourcesSpecBuilder that = (IntegrationPlatformResourcesSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
