package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IntegrationPlatformFluent<A extends IntegrationPlatformFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public IntegrationPlatformFluent.MetadataNested<A> withNewMetadata();
    public IntegrationPlatformFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IntegrationPlatformFluent.MetadataNested<A> editMetadata();
    public IntegrationPlatformFluent.MetadataNested<A> editOrNewMetadata();
    public IntegrationPlatformFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformSpec getSpec();
    public IntegrationPlatformSpec buildSpec();
    public A withSpec(IntegrationPlatformSpec spec);
    public Boolean hasSpec();
    public IntegrationPlatformFluent.SpecNested<A> withNewSpec();
    public IntegrationPlatformFluent.SpecNested<A> withNewSpecLike(IntegrationPlatformSpec item);
    public IntegrationPlatformFluent.SpecNested<A> editSpec();
    public IntegrationPlatformFluent.SpecNested<A> editOrNewSpec();
    public IntegrationPlatformFluent.SpecNested<A> editOrNewSpecLike(IntegrationPlatformSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationPlatformStatus getStatus();
    public IntegrationPlatformStatus buildStatus();
    public A withStatus(IntegrationPlatformStatus status);
    public Boolean hasStatus();
    public IntegrationPlatformFluent.StatusNested<A> withNewStatus();
    public IntegrationPlatformFluent.StatusNested<A> withNewStatusLike(IntegrationPlatformStatus item);
    public IntegrationPlatformFluent.StatusNested<A> editStatus();
    public IntegrationPlatformFluent.StatusNested<A> editOrNewStatus();
    public IntegrationPlatformFluent.StatusNested<A> editOrNewStatusLike(IntegrationPlatformStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IntegrationPlatformFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationPlatformSpecFluent<IntegrationPlatformFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationPlatformStatusFluent<IntegrationPlatformFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
