package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationKitStatusBuilder extends IntegrationKitStatusFluentImpl<IntegrationKitStatusBuilder> implements VisitableBuilder<IntegrationKitStatus,IntegrationKitStatusBuilder> {

    IntegrationKitStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationKitStatusBuilder() {
        this(true);
    }

    public IntegrationKitStatusBuilder(Boolean validationEnabled) {
        this(new IntegrationKitStatus(), validationEnabled);
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationKitStatus(), validationEnabled);
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,IntegrationKitStatus instance) {
        this(fluent, instance, true);
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,IntegrationKitStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifacts(instance.getArtifacts()); 
        fluent.withBaseImage(instance.getBaseImage()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDigest(instance.getDigest()); 
        fluent.withFailure(instance.getFailure()); 
        fluent.withImage(instance.getImage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withPlatform(instance.getPlatform()); 
        fluent.withRuntimeProvider(instance.getRuntimeProvider()); 
        fluent.withRuntimeVersion(instance.getRuntimeVersion()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatus instance) {
        this(instance,true);
    }

    public IntegrationKitStatusBuilder(IntegrationKitStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifacts(instance.getArtifacts()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConditions(instance.getConditions()); 
        this.withDigest(instance.getDigest()); 
        this.withFailure(instance.getFailure()); 
        this.withImage(instance.getImage()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withRuntimeProvider(instance.getRuntimeProvider()); 
        this.withRuntimeVersion(instance.getRuntimeVersion()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationKitStatus build() {
        EditableIntegrationKitStatus buildable = new EditableIntegrationKitStatus(fluent.getArtifacts(),fluent.getBaseImage(),fluent.getConditions(),fluent.getDigest(),fluent.getFailure(),fluent.getImage(),fluent.getPhase(),fluent.getPlatform(),fluent.getRuntimeProvider(),fluent.getRuntimeVersion(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationKitStatusBuilder that = (IntegrationKitStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
