package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationKitBuilder extends IntegrationKitFluentImpl<IntegrationKitBuilder> implements VisitableBuilder<IntegrationKit,IntegrationKitBuilder> {

    IntegrationKitFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationKitBuilder() {
        this(true);
    }

    public IntegrationKitBuilder(Boolean validationEnabled) {
        this(new IntegrationKit(), validationEnabled);
    }

    public IntegrationKitBuilder(IntegrationKitFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationKitBuilder(IntegrationKitFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationKit(), validationEnabled);
    }

    public IntegrationKitBuilder(IntegrationKitFluent<?> fluent,IntegrationKit instance) {
        this(fluent, instance, true);
    }

    public IntegrationKitBuilder(IntegrationKitFluent<?> fluent,IntegrationKit instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationKitBuilder(IntegrationKit instance) {
        this(instance,true);
    }

    public IntegrationKitBuilder(IntegrationKit instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationKit build() {
        EditableIntegrationKit buildable = new EditableIntegrationKit(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationKitBuilder that = (IntegrationKitBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
