package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IntegrationFluent<A extends IntegrationFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public IntegrationFluent.MetadataNested<A> withNewMetadata();
    public IntegrationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IntegrationFluent.MetadataNested<A> editMetadata();
    public IntegrationFluent.MetadataNested<A> editOrNewMetadata();
    public IntegrationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationSpec getSpec();
    public IntegrationSpec buildSpec();
    public A withSpec(IntegrationSpec spec);
    public Boolean hasSpec();
    public IntegrationFluent.SpecNested<A> withNewSpec();
    public IntegrationFluent.SpecNested<A> withNewSpecLike(IntegrationSpec item);
    public IntegrationFluent.SpecNested<A> editSpec();
    public IntegrationFluent.SpecNested<A> editOrNewSpec();
    public IntegrationFluent.SpecNested<A> editOrNewSpecLike(IntegrationSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public IntegrationStatus getStatus();
    public IntegrationStatus buildStatus();
    public A withStatus(IntegrationStatus status);
    public Boolean hasStatus();
    public IntegrationFluent.StatusNested<A> withNewStatus();
    public IntegrationFluent.StatusNested<A> withNewStatusLike(IntegrationStatus item);
    public IntegrationFluent.StatusNested<A> editStatus();
    public IntegrationFluent.StatusNested<A> editOrNewStatus();
    public IntegrationFluent.StatusNested<A> editOrNewStatusLike(IntegrationStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IntegrationFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationSpecFluent<IntegrationFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntegrationStatusFluent<IntegrationFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
