package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ImageTaskFluent<A extends ImageTaskFluent<A>> extends Fluent<A> {


    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(Predicate<String> predicate);
    public Boolean hasMatchingArg(Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(int[] arg1,int arg2,int arg3);
    public A addNewArg(char[] arg1);
    public A addNewArg(StringBuffer arg1);
    public A addNewArg(byte[] arg1,int arg2);
    public A addNewArg(byte[] arg1);
    public A addNewArg(char[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewArg(String arg1);
    public String getBuiltImage();
    public A withBuiltImage(String builtImage);
    public Boolean hasBuiltImage();
    public A withNewBuiltImage(StringBuilder arg1);
    public A withNewBuiltImage(int[] arg1,int arg2,int arg3);
    public A withNewBuiltImage(char[] arg1);
    public A withNewBuiltImage(StringBuffer arg1);
    public A withNewBuiltImage(byte[] arg1,int arg2);
    public A withNewBuiltImage(byte[] arg1);
    public A withNewBuiltImage(char[] arg1,int arg2,int arg3);
    public A withNewBuiltImage(byte[] arg1,int arg2,int arg3);
    public A withNewBuiltImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBuiltImage(String arg1);
    public A addToCommand(int index,String item);
    public A setToCommand(int index,String item);
    public A addToCommand(String... items);
    public A addAllToCommand(Collection<String> items);
    public A removeFromCommand(String... items);
    public A removeAllFromCommand(Collection<String> items);
    public List<String> getCommand();
    public String getCommand(int index);
    public String getFirstCommand();
    public String getLastCommand();
    public String getMatchingCommand(Predicate<String> predicate);
    public Boolean hasMatchingCommand(Predicate<String> predicate);
    public A withCommand(List<String> command);
    public A withCommand(String... command);
    public Boolean hasCommand();
    public A addNewCommand(StringBuilder arg1);
    public A addNewCommand(int[] arg1,int arg2,int arg3);
    public A addNewCommand(char[] arg1);
    public A addNewCommand(StringBuffer arg1);
    public A addNewCommand(byte[] arg1,int arg2);
    public A addNewCommand(byte[] arg1);
    public A addNewCommand(char[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3);
    public A addNewCommand(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewCommand(String arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public List<EnvVar> getEnv();
    public List<EnvVar> buildEnv();
    public EnvVar buildEnv(int index);
    public EnvVar buildFirstEnv();
    public EnvVar buildLastEnv();
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public ImageTaskFluent.EnvNested<A> addNewEnv();
    public ImageTaskFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public ImageTaskFluent.EnvNested<A> setNewEnvLike(int index,EnvVar item);
    public ImageTaskFluent.EnvNested<A> editEnv(int index);
    public ImageTaskFluent.EnvNested<A> editFirstEnv();
    public ImageTaskFluent.EnvNested<A> editLastEnv();
    public ImageTaskFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public SecurityContext getSecurityContext();
    public A withSecurityContext(SecurityContext securityContext);
    public Boolean hasSecurityContext();
    public A addToVolumeMounts(int index,VolumeMount item);
    public A setToVolumeMounts(int index,VolumeMount item);
    public A addToVolumeMounts(VolumeMount... items);
    public A addAllToVolumeMounts(Collection<VolumeMount> items);
    public A removeFromVolumeMounts(VolumeMount... items);
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items);
    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts();
    public List<VolumeMount> buildVolumeMounts();
    public VolumeMount buildVolumeMount(int index);
    public VolumeMount buildFirstVolumeMount();
    public VolumeMount buildLastVolumeMount();
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public A withVolumeMounts(List<VolumeMount> volumeMounts);
    public A withVolumeMounts(VolumeMount... volumeMounts);
    public Boolean hasVolumeMounts();
    public ImageTaskFluent.VolumeMountsNested<A> addNewVolumeMount();
    public ImageTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item);
    public ImageTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item);
    public ImageTaskFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public ImageTaskFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public ImageTaskFluent.VolumeMountsNested<A> editLastVolumeMount();
    public ImageTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate);
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public ImageTaskFluent.VolumesNested<A> addNewVolume();
    public ImageTaskFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public ImageTaskFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public ImageTaskFluent.VolumesNested<A> editVolume(int index);
    public ImageTaskFluent.VolumesNested<A> editFirstVolume();
    public ImageTaskFluent.VolumesNested<A> editLastVolume();
    public ImageTaskFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
    public String getWorkingDir();
    public A withWorkingDir(String workingDir);
    public Boolean hasWorkingDir();
    public A withNewWorkingDir(StringBuilder arg1);
    public A withNewWorkingDir(int[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(char[] arg1);
    public A withNewWorkingDir(StringBuffer arg1);
    public A withNewWorkingDir(byte[] arg1,int arg2);
    public A withNewWorkingDir(byte[] arg1);
    public A withNewWorkingDir(char[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3);
    public A withNewWorkingDir(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewWorkingDir(String arg1);
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<ImageTaskFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeMountFluent<ImageTaskFluent.VolumeMountsNested<N>> {

            public N and();
            public N endVolumeMount();    }


    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<ImageTaskFluent.VolumesNested<N>> {

            public N and();
            public N endVolume();    }


}
