package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class FailureFluentImpl<A extends FailureFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FailureFluent<A> {

    private String reason;
    private FailureRecoveryBuilder recovery;
    private String time;

    public FailureFluentImpl() {
    }

    public FailureFluentImpl(Failure instance) {
        this.withReason(instance.getReason()); 
        this.withRecovery(instance.getRecovery()); 
        this.withTime(instance.getTime()); 
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(int[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(char[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(byte[] arg1,int arg2) {
        return (A)withReason(new String(arg1, arg2));
    }

    public A withNewReason(byte[] arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(char[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3) {
        return (A)withReason(new String(arg1, arg2, arg3));
    }

    public A withNewReason(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReason(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRecovery instead.
 * @return The buildable object.
 */
@Deprecated public FailureRecovery getRecovery() {
        return this.recovery!=null?this.recovery.build():null;
    }

    public FailureRecovery buildRecovery() {
        return this.recovery!=null?this.recovery.build():null;
    }

    public A withRecovery(FailureRecovery recovery) {
        _visitables.get("recovery").remove(this.recovery);
        if (recovery!=null){ this.recovery= new FailureRecoveryBuilder(recovery); _visitables.get("recovery").add(this.recovery);} return (A) this;
    }

    public Boolean hasRecovery() {
        return this.recovery != null;
    }

    public A withNewRecovery(Integer attempt,Integer attemptMax,String attemptTime) {
        return (A)withRecovery(new FailureRecovery(attempt, attemptMax, attemptTime));
    }

    public FailureFluent.RecoveryNested<A> withNewRecovery() {
        return new RecoveryNestedImpl();
    }

    public FailureFluent.RecoveryNested<A> withNewRecoveryLike(FailureRecovery item) {
        return new RecoveryNestedImpl(item);
    }

    public FailureFluent.RecoveryNested<A> editRecovery() {
        return withNewRecoveryLike(getRecovery());
    }

    public FailureFluent.RecoveryNested<A> editOrNewRecovery() {
        return withNewRecoveryLike(getRecovery() != null ? getRecovery(): new FailureRecoveryBuilder().build());
    }

    public FailureFluent.RecoveryNested<A> editOrNewRecoveryLike(FailureRecovery item) {
        return withNewRecoveryLike(getRecovery() != null ? getRecovery(): item);
    }

    public String getTime() {
        return this.time;
    }

    public A withTime(String time) {
        this.time=time; return (A) this;
    }

    public Boolean hasTime() {
        return this.time != null;
    }

    public A withNewTime(StringBuilder arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(int[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(char[] arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(StringBuffer arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(byte[] arg1,int arg2) {
        return (A)withTime(new String(arg1, arg2));
    }

    public A withNewTime(byte[] arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(char[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(byte[] arg1,int arg2,int arg3) {
        return (A)withTime(new String(arg1, arg2, arg3));
    }

    public A withNewTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTime(String arg1) {
        return (A)withTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FailureFluentImpl that = (FailureFluentImpl) o;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (recovery != null ? !recovery.equals(that.recovery) :that.recovery != null) return false;
        if (time != null ? !time.equals(that.time) :that.time != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(reason,  recovery,  time,  super.hashCode());
    }

    public class RecoveryNestedImpl<N> extends FailureRecoveryFluentImpl<FailureFluent.RecoveryNested<N>> implements FailureFluent.RecoveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FailureRecoveryBuilder builder;

            RecoveryNestedImpl(FailureRecovery item) {
                this.builder = new FailureRecoveryBuilder(this, item);
                        
            }

            RecoveryNestedImpl() {
                this.builder = new FailureRecoveryBuilder(this);
                        
            }

            public N and() {
                return (N) FailureFluentImpl.this.withRecovery(builder.build());
            }

            public N endRecovery() {
                return and();
            }
    }


}
