package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FailureBuilder extends FailureFluentImpl<FailureBuilder> implements VisitableBuilder<Failure,FailureBuilder> {

    FailureFluent<?> fluent;
    Boolean validationEnabled;

    public FailureBuilder() {
        this(true);
    }

    public FailureBuilder(Boolean validationEnabled) {
        this(new Failure(), validationEnabled);
    }

    public FailureBuilder(FailureFluent<?> fluent) {
        this(fluent, true);
    }

    public FailureBuilder(FailureFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Failure(), validationEnabled);
    }

    public FailureBuilder(FailureFluent<?> fluent,Failure instance) {
        this(fluent, instance, true);
    }

    public FailureBuilder(FailureFluent<?> fluent,Failure instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReason(instance.getReason()); 
        fluent.withRecovery(instance.getRecovery()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public FailureBuilder(Failure instance) {
        this(instance,true);
    }

    public FailureBuilder(Failure instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReason(instance.getReason()); 
        this.withRecovery(instance.getRecovery()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableFailure build() {
        EditableFailure buildable = new EditableFailure(fluent.getReason(),fluent.getRecovery(),fluent.getTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FailureBuilder that = (FailureBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
