package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CamelSchemeScopeFluent<A extends CamelSchemeScopeFluent<A>> extends Fluent<A> {


    public A addToDependencies(int index,CamelArtifactDependency item);
    public A setToDependencies(int index,CamelArtifactDependency item);
    public A addToDependencies(CamelArtifactDependency... items);
    public A addAllToDependencies(Collection<CamelArtifactDependency> items);
    public A removeFromDependencies(CamelArtifactDependency... items);
    public A removeAllFromDependencies(Collection<CamelArtifactDependency> items);
    public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactDependency> getDependencies();
    public List<CamelArtifactDependency> buildDependencies();
    public CamelArtifactDependency buildDependency(int index);
    public CamelArtifactDependency buildFirstDependency();
    public CamelArtifactDependency buildLastDependency();
    public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public A withDependencies(List<CamelArtifactDependency> dependencies);
    public A withDependencies(CamelArtifactDependency... dependencies);
    public Boolean hasDependencies();
    public CamelSchemeScopeFluent.DependenciesNested<A> addNewDependency();
    public CamelSchemeScopeFluent.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item);
    public CamelSchemeScopeFluent.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item);
    public CamelSchemeScopeFluent.DependenciesNested<A> editDependency(int index);
    public CamelSchemeScopeFluent.DependenciesNested<A> editFirstDependency();
    public CamelSchemeScopeFluent.DependenciesNested<A> editLastDependency();
    public CamelSchemeScopeFluent.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
    public interface DependenciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelArtifactDependencyFluent<CamelSchemeScopeFluent.DependenciesNested<N>> {

            public N and();
            public N endDependency();    }


}
