package io.fabric8.camelk.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CamelSchemeFluentImpl<A extends CamelSchemeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CamelSchemeFluent<A> {

    private CamelSchemeScopeBuilder consumer;
    private Boolean http;
    private String id;
    private Boolean passive;
    private CamelSchemeScopeBuilder producer;

    public CamelSchemeFluentImpl() {
    }

    public CamelSchemeFluentImpl(CamelScheme instance) {
        this.withConsumer(instance.getConsumer()); 
        this.withHttp(instance.getHttp()); 
        this.withId(instance.getId()); 
        this.withPassive(instance.getPassive()); 
        this.withProducer(instance.getProducer()); 
    }

    
/**
 * This method has been deprecated, please use method buildConsumer instead.
 * @return The buildable object.
 */
@Deprecated public CamelSchemeScope getConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public CamelSchemeScope buildConsumer() {
        return this.consumer!=null?this.consumer.build():null;
    }

    public A withConsumer(CamelSchemeScope consumer) {
        _visitables.get("consumer").remove(this.consumer);
        if (consumer!=null){ this.consumer= new CamelSchemeScopeBuilder(consumer); _visitables.get("consumer").add(this.consumer);} return (A) this;
    }

    public Boolean hasConsumer() {
        return this.consumer != null;
    }

    public CamelSchemeFluent.ConsumerNested<A> withNewConsumer() {
        return new ConsumerNestedImpl();
    }

    public CamelSchemeFluent.ConsumerNested<A> withNewConsumerLike(CamelSchemeScope item) {
        return new ConsumerNestedImpl(item);
    }

    public CamelSchemeFluent.ConsumerNested<A> editConsumer() {
        return withNewConsumerLike(getConsumer());
    }

    public CamelSchemeFluent.ConsumerNested<A> editOrNewConsumer() {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): new CamelSchemeScopeBuilder().build());
    }

    public CamelSchemeFluent.ConsumerNested<A> editOrNewConsumerLike(CamelSchemeScope item) {
        return withNewConsumerLike(getConsumer() != null ? getConsumer(): item);
    }

    public Boolean getHttp() {
        return this.http;
    }

    public A withHttp(Boolean http) {
        this.http=http; return (A) this;
    }

    public Boolean hasHttp() {
        return this.http != null;
    }

    public A withNewHttp(String arg1) {
        return (A)withHttp(new Boolean(arg1));
    }

    public A withNewHttp(boolean arg1) {
        return (A)withHttp(new Boolean(arg1));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id=id; return (A) this;
    }

    public Boolean hasId() {
        return this.id != null;
    }

    public A withNewId(StringBuilder arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(int[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(char[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuffer arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(byte[] arg1,int arg2) {
        return (A)withId(new String(arg1, arg2));
    }

    public A withNewId(byte[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(char[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewId(String arg1) {
        return (A)withId(new String(arg1));
    }

    public Boolean getPassive() {
        return this.passive;
    }

    public A withPassive(Boolean passive) {
        this.passive=passive; return (A) this;
    }

    public Boolean hasPassive() {
        return this.passive != null;
    }

    public A withNewPassive(String arg1) {
        return (A)withPassive(new Boolean(arg1));
    }

    public A withNewPassive(boolean arg1) {
        return (A)withPassive(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildProducer instead.
 * @return The buildable object.
 */
@Deprecated public CamelSchemeScope getProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public CamelSchemeScope buildProducer() {
        return this.producer!=null?this.producer.build():null;
    }

    public A withProducer(CamelSchemeScope producer) {
        _visitables.get("producer").remove(this.producer);
        if (producer!=null){ this.producer= new CamelSchemeScopeBuilder(producer); _visitables.get("producer").add(this.producer);} return (A) this;
    }

    public Boolean hasProducer() {
        return this.producer != null;
    }

    public CamelSchemeFluent.ProducerNested<A> withNewProducer() {
        return new ProducerNestedImpl();
    }

    public CamelSchemeFluent.ProducerNested<A> withNewProducerLike(CamelSchemeScope item) {
        return new ProducerNestedImpl(item);
    }

    public CamelSchemeFluent.ProducerNested<A> editProducer() {
        return withNewProducerLike(getProducer());
    }

    public CamelSchemeFluent.ProducerNested<A> editOrNewProducer() {
        return withNewProducerLike(getProducer() != null ? getProducer(): new CamelSchemeScopeBuilder().build());
    }

    public CamelSchemeFluent.ProducerNested<A> editOrNewProducerLike(CamelSchemeScope item) {
        return withNewProducerLike(getProducer() != null ? getProducer(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelSchemeFluentImpl that = (CamelSchemeFluentImpl) o;
        if (consumer != null ? !consumer.equals(that.consumer) :that.consumer != null) return false;
        if (http != null ? !http.equals(that.http) :that.http != null) return false;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        if (passive != null ? !passive.equals(that.passive) :that.passive != null) return false;
        if (producer != null ? !producer.equals(that.producer) :that.producer != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(consumer,  http,  id,  passive,  producer,  super.hashCode());
    }

    public class ConsumerNestedImpl<N> extends CamelSchemeScopeFluentImpl<CamelSchemeFluent.ConsumerNested<N>> implements CamelSchemeFluent.ConsumerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelSchemeScopeBuilder builder;

            ConsumerNestedImpl(CamelSchemeScope item) {
                this.builder = new CamelSchemeScopeBuilder(this, item);
                        
            }

            ConsumerNestedImpl() {
                this.builder = new CamelSchemeScopeBuilder(this);
                        
            }

            public N and() {
                return (N) CamelSchemeFluentImpl.this.withConsumer(builder.build());
            }

            public N endConsumer() {
                return and();
            }
    }


    public class ProducerNestedImpl<N> extends CamelSchemeScopeFluentImpl<CamelSchemeFluent.ProducerNested<N>> implements CamelSchemeFluent.ProducerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelSchemeScopeBuilder builder;

            ProducerNestedImpl(CamelSchemeScope item) {
                this.builder = new CamelSchemeScopeBuilder(this, item);
                        
            }

            ProducerNestedImpl() {
                this.builder = new CamelSchemeScopeBuilder(this);
                        
            }

            public N and() {
                return (N) CamelSchemeFluentImpl.this.withProducer(builder.build());
            }

            public N endProducer() {
                return and();
            }
    }


}
