package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelCatalogListBuilder extends CamelCatalogListFluentImpl<CamelCatalogListBuilder> implements VisitableBuilder<CamelCatalogList,CamelCatalogListBuilder> {

    CamelCatalogListFluent<?> fluent;
    Boolean validationEnabled;

    public CamelCatalogListBuilder() {
        this(true);
    }

    public CamelCatalogListBuilder(Boolean validationEnabled) {
        this(new CamelCatalogList(), validationEnabled);
    }

    public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelCatalogList(), validationEnabled);
    }

    public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,CamelCatalogList instance) {
        this(fluent, instance, true);
    }

    public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,CamelCatalogList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelCatalogListBuilder(CamelCatalogList instance) {
        this(instance,true);
    }

    public CamelCatalogListBuilder(CamelCatalogList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelCatalogList build() {
        EditableCamelCatalogList buildable = new EditableCamelCatalogList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelCatalogListBuilder that = (CamelCatalogListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
