package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class CamelArtifactFluentImpl<A extends CamelArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CamelArtifactFluent<A> {

    private String artifactId;
    private List<String> dataformats;
    private List<CamelArtifactDependencyBuilder> dependencies;
    private List<CamelArtifactExclusionBuilder> exclusions;
    private String groupId;
    private List<String> javaTypes;
    private List<String> languages;
    private List<CamelSchemeBuilder> schemes;
    private String version;

    public CamelArtifactFluentImpl() {
    }

    public CamelArtifactFluentImpl(CamelArtifact instance) {
        this.withArtifactId(instance.getArtifactId()); 
        this.withDataformats(instance.getDataformats()); 
        this.withDependencies(instance.getDependencies()); 
        this.withExclusions(instance.getExclusions()); 
        this.withGroupId(instance.getGroupId()); 
        this.withJavaTypes(instance.getJavaTypes()); 
        this.withLanguages(instance.getLanguages()); 
        this.withSchemes(instance.getSchemes()); 
        this.withVersion(instance.getVersion()); 
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(String artifactId) {
        this.artifactId=artifactId; return (A) this;
    }

    public Boolean hasArtifactId() {
        return this.artifactId != null;
    }

    public A withNewArtifactId(StringBuilder arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(int[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(char[] arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(StringBuffer arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(byte[] arg1,int arg2) {
        return (A)withArtifactId(new String(arg1, arg2));
    }

    public A withNewArtifactId(byte[] arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A withNewArtifactId(char[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(byte[] arg1,int arg2,int arg3) {
        return (A)withArtifactId(new String(arg1, arg2, arg3));
    }

    public A withNewArtifactId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withArtifactId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewArtifactId(String arg1) {
        return (A)withArtifactId(new String(arg1));
    }

    public A addToDataformats(int index,String item) {
        if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
        this.dataformats.add(index, item);
        return (A)this;
    }

    public A setToDataformats(int index,String item) {
        if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
        this.dataformats.set(index, item); return (A)this;
    }

    public A addToDataformats(String... items) {
        if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
        for (String item : items) {this.dataformats.add(item);} return (A)this;
    }

    public A addAllToDataformats(Collection<String> items) {
        if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
        for (String item : items) {this.dataformats.add(item);} return (A)this;
    }

    public A removeFromDataformats(String... items) {
        for (String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
    }

    public A removeAllFromDataformats(Collection<String> items) {
        for (String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
    }

    public List<String> getDataformats() {
        return this.dataformats;
    }

    public String getDataformat(int index) {
        return this.dataformats.get(index);
    }

    public String getFirstDataformat() {
        return this.dataformats.get(0);
    }

    public String getLastDataformat() {
        return this.dataformats.get(dataformats.size() - 1);
    }

    public String getMatchingDataformat(Predicate<String> predicate) {
        for (String item: dataformats) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDataformat(Predicate<String> predicate) {
        for (String item: dataformats) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDataformats(List<String> dataformats) {
        if (this.dataformats != null) { _visitables.get("dataformats").removeAll(this.dataformats);}
        if (dataformats != null) {this.dataformats = new ArrayList<String>(); for (String item : dataformats){this.addToDataformats(item);}} else { this.dataformats = null;} return (A) this;
    }

    public A withDataformats(String... dataformats) {
        if (this.dataformats != null) {this.dataformats.clear();}
        if (dataformats != null) {for (String item :dataformats){ this.addToDataformats(item);}} return (A) this;
    }

    public Boolean hasDataformats() {
        return dataformats != null && !dataformats.isEmpty();
    }

    public A addNewDataformat(StringBuilder arg1) {
        return (A)addToDataformats(new String(arg1));
    }

    public A addNewDataformat(int[] arg1,int arg2,int arg3) {
        return (A)addToDataformats(new String(arg1, arg2, arg3));
    }

    public A addNewDataformat(char[] arg1) {
        return (A)addToDataformats(new String(arg1));
    }

    public A addNewDataformat(StringBuffer arg1) {
        return (A)addToDataformats(new String(arg1));
    }

    public A addNewDataformat(byte[] arg1,int arg2) {
        return (A)addToDataformats(new String(arg1, arg2));
    }

    public A addNewDataformat(byte[] arg1) {
        return (A)addToDataformats(new String(arg1));
    }

    public A addNewDataformat(char[] arg1,int arg2,int arg3) {
        return (A)addToDataformats(new String(arg1, arg2, arg3));
    }

    public A addNewDataformat(byte[] arg1,int arg2,int arg3) {
        return (A)addToDataformats(new String(arg1, arg2, arg3));
    }

    public A addNewDataformat(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToDataformats(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewDataformat(String arg1) {
        return (A)addToDataformats(new String(arg1));
    }

    public A addToDependencies(int index,CamelArtifactDependency item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
    }

    public A setToDependencies(int index,CamelArtifactDependency item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);
        if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
        if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
         return (A)this;
    }

    public A addToDependencies(CamelArtifactDependency... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A addAllToDependencies(Collection<CamelArtifactDependency> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
    }

    public A removeFromDependencies(CamelArtifactDependency... items) {
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<CamelArtifactDependency> items) {
        for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate) {
        if (dependencies == null) return (A) this;
        final Iterator<CamelArtifactDependencyBuilder> each = dependencies.iterator();
        final List visitables = _visitables.get("dependencies");
        while (each.hasNext()) {
          CamelArtifactDependencyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDependencies instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactDependency> getDependencies() {
        return build(dependencies);
    }

    public List<CamelArtifactDependency> buildDependencies() {
        return build(dependencies);
    }

    public CamelArtifactDependency buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public CamelArtifactDependency buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public CamelArtifactDependency buildLastDependency() {
        return this.dependencies.get(dependencies.size() - 1).build();
    }

    public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<CamelArtifactDependency> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>(); for (CamelArtifactDependency item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(CamelArtifactDependency... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (CamelArtifactDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public CamelArtifactFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    public CamelArtifactFluent.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item) {
        return new DependenciesNestedImpl(-1, item);
    }

    public CamelArtifactFluent.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item) {
        return new DependenciesNestedImpl(index, item);
    }

    public CamelArtifactFluent.DependenciesNested<A> editDependency(int index) {
        if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public CamelArtifactFluent.DependenciesNested<A> editFirstDependency() {
        if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        return setNewDependencyLike(0, buildDependency(0));
    }

    public CamelArtifactFluent.DependenciesNested<A> editLastDependency() {
        int index = dependencies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public CamelArtifactFluent.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<dependencies.size();i++) { 
        if (predicate.test(dependencies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
        return setNewDependencyLike(index, buildDependency(index));
    }

    public A addToExclusions(int index,CamelArtifactExclusion item) {
        if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
        CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(index >= 0 ? index : _visitables.get("exclusions").size(), builder);this.exclusions.add(index >= 0 ? index : exclusions.size(), builder); return (A)this;
    }

    public A setToExclusions(int index,CamelArtifactExclusion item) {
        if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
        CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
        if (index < 0 || index >= _visitables.get("exclusions").size()) { _visitables.get("exclusions").add(builder); } else { _visitables.get("exclusions").set(index, builder);}
        if (index < 0 || index >= exclusions.size()) { exclusions.add(builder); } else { exclusions.set(index, builder);}
         return (A)this;
    }

    public A addToExclusions(CamelArtifactExclusion... items) {
        if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
        for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
    }

    public A addAllToExclusions(Collection<CamelArtifactExclusion> items) {
        if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
        for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
    }

    public A removeFromExclusions(CamelArtifactExclusion... items) {
        for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
    }

    public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items) {
        for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate) {
        if (exclusions == null) return (A) this;
        final Iterator<CamelArtifactExclusionBuilder> each = exclusions.iterator();
        final List visitables = _visitables.get("exclusions");
        while (each.hasNext()) {
          CamelArtifactExclusionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildExclusions instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactExclusion> getExclusions() {
        return build(exclusions);
    }

    public List<CamelArtifactExclusion> buildExclusions() {
        return build(exclusions);
    }

    public CamelArtifactExclusion buildExclusion(int index) {
        return this.exclusions.get(index).build();
    }

    public CamelArtifactExclusion buildFirstExclusion() {
        return this.exclusions.get(0).build();
    }

    public CamelArtifactExclusion buildLastExclusion() {
        return this.exclusions.get(exclusions.size() - 1).build();
    }

    public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withExclusions(List<CamelArtifactExclusion> exclusions) {
        if (this.exclusions != null) { _visitables.get("exclusions").removeAll(this.exclusions);}
        if (exclusions != null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>(); for (CamelArtifactExclusion item : exclusions){this.addToExclusions(item);}} else { this.exclusions = null;} return (A) this;
    }

    public A withExclusions(CamelArtifactExclusion... exclusions) {
        if (this.exclusions != null) {this.exclusions.clear();}
        if (exclusions != null) {for (CamelArtifactExclusion item :exclusions){ this.addToExclusions(item);}} return (A) this;
    }

    public Boolean hasExclusions() {
        return exclusions != null && !exclusions.isEmpty();
    }

    public A addNewExclusion(String artifactId,String groupId) {
        return (A)addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
    }

    public CamelArtifactFluent.ExclusionsNested<A> addNewExclusion() {
        return new ExclusionsNestedImpl();
    }

    public CamelArtifactFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item) {
        return new ExclusionsNestedImpl(-1, item);
    }

    public CamelArtifactFluent.ExclusionsNested<A> setNewExclusionLike(int index,CamelArtifactExclusion item) {
        return new ExclusionsNestedImpl(index, item);
    }

    public CamelArtifactFluent.ExclusionsNested<A> editExclusion(int index) {
        if (exclusions.size() <= index) throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public CamelArtifactFluent.ExclusionsNested<A> editFirstExclusion() {
        if (exclusions.size() == 0) throw new RuntimeException("Can't edit first exclusions. The list is empty.");
        return setNewExclusionLike(0, buildExclusion(0));
    }

    public CamelArtifactFluent.ExclusionsNested<A> editLastExclusion() {
        int index = exclusions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last exclusions. The list is empty.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public CamelArtifactFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<exclusions.size();i++) { 
        if (predicate.test(exclusions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching exclusions. No match found.");
        return setNewExclusionLike(index, buildExclusion(index));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId=groupId; return (A) this;
    }

    public Boolean hasGroupId() {
        return this.groupId != null;
    }

    public A withNewGroupId(StringBuilder arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(int[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(char[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(StringBuffer arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(byte[] arg1,int arg2) {
        return (A)withGroupId(new String(arg1, arg2));
    }

    public A withNewGroupId(byte[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(char[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withGroupId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewGroupId(String arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A addToJavaTypes(int index,String item) {
        if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
        this.javaTypes.add(index, item);
        return (A)this;
    }

    public A setToJavaTypes(int index,String item) {
        if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
        this.javaTypes.set(index, item); return (A)this;
    }

    public A addToJavaTypes(String... items) {
        if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
        for (String item : items) {this.javaTypes.add(item);} return (A)this;
    }

    public A addAllToJavaTypes(Collection<String> items) {
        if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
        for (String item : items) {this.javaTypes.add(item);} return (A)this;
    }

    public A removeFromJavaTypes(String... items) {
        for (String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromJavaTypes(Collection<String> items) {
        for (String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
    }

    public List<String> getJavaTypes() {
        return this.javaTypes;
    }

    public String getJavaType(int index) {
        return this.javaTypes.get(index);
    }

    public String getFirstJavaType() {
        return this.javaTypes.get(0);
    }

    public String getLastJavaType() {
        return this.javaTypes.get(javaTypes.size() - 1);
    }

    public String getMatchingJavaType(Predicate<String> predicate) {
        for (String item: javaTypes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingJavaType(Predicate<String> predicate) {
        for (String item: javaTypes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withJavaTypes(List<String> javaTypes) {
        if (this.javaTypes != null) { _visitables.get("javaTypes").removeAll(this.javaTypes);}
        if (javaTypes != null) {this.javaTypes = new ArrayList<String>(); for (String item : javaTypes){this.addToJavaTypes(item);}} else { this.javaTypes = null;} return (A) this;
    }

    public A withJavaTypes(String... javaTypes) {
        if (this.javaTypes != null) {this.javaTypes.clear();}
        if (javaTypes != null) {for (String item :javaTypes){ this.addToJavaTypes(item);}} return (A) this;
    }

    public Boolean hasJavaTypes() {
        return javaTypes != null && !javaTypes.isEmpty();
    }

    public A addNewJavaType(StringBuilder arg1) {
        return (A)addToJavaTypes(new String(arg1));
    }

    public A addNewJavaType(int[] arg1,int arg2,int arg3) {
        return (A)addToJavaTypes(new String(arg1, arg2, arg3));
    }

    public A addNewJavaType(char[] arg1) {
        return (A)addToJavaTypes(new String(arg1));
    }

    public A addNewJavaType(StringBuffer arg1) {
        return (A)addToJavaTypes(new String(arg1));
    }

    public A addNewJavaType(byte[] arg1,int arg2) {
        return (A)addToJavaTypes(new String(arg1, arg2));
    }

    public A addNewJavaType(byte[] arg1) {
        return (A)addToJavaTypes(new String(arg1));
    }

    public A addNewJavaType(char[] arg1,int arg2,int arg3) {
        return (A)addToJavaTypes(new String(arg1, arg2, arg3));
    }

    public A addNewJavaType(byte[] arg1,int arg2,int arg3) {
        return (A)addToJavaTypes(new String(arg1, arg2, arg3));
    }

    public A addNewJavaType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToJavaTypes(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewJavaType(String arg1) {
        return (A)addToJavaTypes(new String(arg1));
    }

    public A addToLanguages(int index,String item) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        this.languages.add(index, item);
        return (A)this;
    }

    public A setToLanguages(int index,String item) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        this.languages.set(index, item); return (A)this;
    }

    public A addToLanguages(String... items) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        for (String item : items) {this.languages.add(item);} return (A)this;
    }

    public A addAllToLanguages(Collection<String> items) {
        if (this.languages == null) {this.languages = new ArrayList<String>();}
        for (String item : items) {this.languages.add(item);} return (A)this;
    }

    public A removeFromLanguages(String... items) {
        for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
    }

    public A removeAllFromLanguages(Collection<String> items) {
        for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    public String getFirstLanguage() {
        return this.languages.get(0);
    }

    public String getLastLanguage() {
        return this.languages.get(languages.size() - 1);
    }

    public String getMatchingLanguage(Predicate<String> predicate) {
        for (String item: languages) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLanguage(Predicate<String> predicate) {
        for (String item: languages) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLanguages(List<String> languages) {
        if (this.languages != null) { _visitables.get("languages").removeAll(this.languages);}
        if (languages != null) {this.languages = new ArrayList<String>(); for (String item : languages){this.addToLanguages(item);}} else { this.languages = null;} return (A) this;
    }

    public A withLanguages(String... languages) {
        if (this.languages != null) {this.languages.clear();}
        if (languages != null) {for (String item :languages){ this.addToLanguages(item);}} return (A) this;
    }

    public Boolean hasLanguages() {
        return languages != null && !languages.isEmpty();
    }

    public A addNewLanguage(StringBuilder arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(int[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(char[] arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(StringBuffer arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(byte[] arg1,int arg2) {
        return (A)addToLanguages(new String(arg1, arg2));
    }

    public A addNewLanguage(byte[] arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addNewLanguage(char[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(byte[] arg1,int arg2,int arg3) {
        return (A)addToLanguages(new String(arg1, arg2, arg3));
    }

    public A addNewLanguage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToLanguages(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewLanguage(String arg1) {
        return (A)addToLanguages(new String(arg1));
    }

    public A addToSchemes(int index,CamelScheme item) {
        if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
        CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").add(index >= 0 ? index : _visitables.get("schemes").size(), builder);this.schemes.add(index >= 0 ? index : schemes.size(), builder); return (A)this;
    }

    public A setToSchemes(int index,CamelScheme item) {
        if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
        CamelSchemeBuilder builder = new CamelSchemeBuilder(item);
        if (index < 0 || index >= _visitables.get("schemes").size()) { _visitables.get("schemes").add(builder); } else { _visitables.get("schemes").set(index, builder);}
        if (index < 0 || index >= schemes.size()) { schemes.add(builder); } else { schemes.set(index, builder);}
         return (A)this;
    }

    public A addToSchemes(CamelScheme... items) {
        if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
        for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
    }

    public A addAllToSchemes(Collection<CamelScheme> items) {
        if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
        for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
    }

    public A removeFromSchemes(CamelScheme... items) {
        for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
    }

    public A removeAllFromSchemes(Collection<CamelScheme> items) {
        for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSchemes(Predicate<CamelSchemeBuilder> predicate) {
        if (schemes == null) return (A) this;
        final Iterator<CamelSchemeBuilder> each = schemes.iterator();
        final List visitables = _visitables.get("schemes");
        while (each.hasNext()) {
          CamelSchemeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSchemes instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelScheme> getSchemes() {
        return build(schemes);
    }

    public List<CamelScheme> buildSchemes() {
        return build(schemes);
    }

    public CamelScheme buildScheme(int index) {
        return this.schemes.get(index).build();
    }

    public CamelScheme buildFirstScheme() {
        return this.schemes.get(0).build();
    }

    public CamelScheme buildLastScheme() {
        return this.schemes.get(schemes.size() - 1).build();
    }

    public CamelScheme buildMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
        for (CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
        for (CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSchemes(List<CamelScheme> schemes) {
        if (this.schemes != null) { _visitables.get("schemes").removeAll(this.schemes);}
        if (schemes != null) {this.schemes = new ArrayList<CamelSchemeBuilder>(); for (CamelScheme item : schemes){this.addToSchemes(item);}} else { this.schemes = null;} return (A) this;
    }

    public A withSchemes(CamelScheme... schemes) {
        if (this.schemes != null) {this.schemes.clear();}
        if (schemes != null) {for (CamelScheme item :schemes){ this.addToSchemes(item);}} return (A) this;
    }

    public Boolean hasSchemes() {
        return schemes != null && !schemes.isEmpty();
    }

    public CamelArtifactFluent.SchemesNested<A> addNewScheme() {
        return new SchemesNestedImpl();
    }

    public CamelArtifactFluent.SchemesNested<A> addNewSchemeLike(CamelScheme item) {
        return new SchemesNestedImpl(-1, item);
    }

    public CamelArtifactFluent.SchemesNested<A> setNewSchemeLike(int index,CamelScheme item) {
        return new SchemesNestedImpl(index, item);
    }

    public CamelArtifactFluent.SchemesNested<A> editScheme(int index) {
        if (schemes.size() <= index) throw new RuntimeException("Can't edit schemes. Index exceeds size.");
        return setNewSchemeLike(index, buildScheme(index));
    }

    public CamelArtifactFluent.SchemesNested<A> editFirstScheme() {
        if (schemes.size() == 0) throw new RuntimeException("Can't edit first schemes. The list is empty.");
        return setNewSchemeLike(0, buildScheme(0));
    }

    public CamelArtifactFluent.SchemesNested<A> editLastScheme() {
        int index = schemes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last schemes. The list is empty.");
        return setNewSchemeLike(index, buildScheme(index));
    }

    public CamelArtifactFluent.SchemesNested<A> editMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<schemes.size();i++) { 
        if (predicate.test(schemes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching schemes. No match found.");
        return setNewSchemeLike(index, buildScheme(index));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CamelArtifactFluentImpl that = (CamelArtifactFluentImpl) o;
        if (artifactId != null ? !artifactId.equals(that.artifactId) :that.artifactId != null) return false;
        if (dataformats != null ? !dataformats.equals(that.dataformats) :that.dataformats != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (exclusions != null ? !exclusions.equals(that.exclusions) :that.exclusions != null) return false;
        if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
        if (javaTypes != null ? !javaTypes.equals(that.javaTypes) :that.javaTypes != null) return false;
        if (languages != null ? !languages.equals(that.languages) :that.languages != null) return false;
        if (schemes != null ? !schemes.equals(that.schemes) :that.schemes != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifactId,  dataformats,  dependencies,  exclusions,  groupId,  javaTypes,  languages,  schemes,  version,  super.hashCode());
    }

    public class DependenciesNestedImpl<N> extends CamelArtifactDependencyFluentImpl<CamelArtifactFluent.DependenciesNested<N>> implements CamelArtifactFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelArtifactDependencyBuilder builder;
        private final int index;

            DependenciesNestedImpl(int index,CamelArtifactDependency item) {
                this.index = index;
                this.builder = new CamelArtifactDependencyBuilder(this, item);
                        
            }

            DependenciesNestedImpl() {
                this.index = -1;
                this.builder = new CamelArtifactDependencyBuilder(this);
                        
            }

            public N and() {
                return (N) CamelArtifactFluentImpl.this.setToDependencies(index,builder.build());
            }

            public N endDependency() {
                return and();
            }
    }


    public class ExclusionsNestedImpl<N> extends CamelArtifactExclusionFluentImpl<CamelArtifactFluent.ExclusionsNested<N>> implements CamelArtifactFluent.ExclusionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelArtifactExclusionBuilder builder;
        private final int index;

            ExclusionsNestedImpl(int index,CamelArtifactExclusion item) {
                this.index = index;
                this.builder = new CamelArtifactExclusionBuilder(this, item);
                        
            }

            ExclusionsNestedImpl() {
                this.index = -1;
                this.builder = new CamelArtifactExclusionBuilder(this);
                        
            }

            public N and() {
                return (N) CamelArtifactFluentImpl.this.setToExclusions(index,builder.build());
            }

            public N endExclusion() {
                return and();
            }
    }


    public class SchemesNestedImpl<N> extends CamelSchemeFluentImpl<CamelArtifactFluent.SchemesNested<N>> implements CamelArtifactFluent.SchemesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CamelSchemeBuilder builder;
        private final int index;

            SchemesNestedImpl(int index,CamelScheme item) {
                this.index = index;
                this.builder = new CamelSchemeBuilder(this, item);
                        
            }

            SchemesNestedImpl() {
                this.index = -1;
                this.builder = new CamelSchemeBuilder(this);
                        
            }

            public N and() {
                return (N) CamelArtifactFluentImpl.this.setToSchemes(index,builder.build());
            }

            public N endScheme() {
                return and();
            }
    }


}
