package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelArtifactExclusionBuilder extends CamelArtifactExclusionFluentImpl<CamelArtifactExclusionBuilder> implements VisitableBuilder<CamelArtifactExclusion,CamelArtifactExclusionBuilder> {

    CamelArtifactExclusionFluent<?> fluent;
    Boolean validationEnabled;

    public CamelArtifactExclusionBuilder() {
        this(true);
    }

    public CamelArtifactExclusionBuilder(Boolean validationEnabled) {
        this(new CamelArtifactExclusion(), validationEnabled);
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelArtifactExclusion(), validationEnabled);
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,CamelArtifactExclusion instance) {
        this(fluent, instance, true);
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusionFluent<?> fluent,CamelArtifactExclusion instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withGroupId(instance.getGroupId()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusion instance) {
        this(instance,true);
    }

    public CamelArtifactExclusionBuilder(CamelArtifactExclusion instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withGroupId(instance.getGroupId()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelArtifactExclusion build() {
        EditableCamelArtifactExclusion buildable = new EditableCamelArtifactExclusion(fluent.getArtifactId(),fluent.getGroupId());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelArtifactExclusionBuilder that = (CamelArtifactExclusionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
