package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CamelArtifactDependencyFluent<A extends CamelArtifactDependencyFluent<A>> extends Fluent<A> {


    public String getArtifactId();
    public A withArtifactId(String artifactId);
    public Boolean hasArtifactId();
    public A withNewArtifactId(StringBuilder arg1);
    public A withNewArtifactId(int[] arg1,int arg2,int arg3);
    public A withNewArtifactId(char[] arg1);
    public A withNewArtifactId(StringBuffer arg1);
    public A withNewArtifactId(byte[] arg1,int arg2);
    public A withNewArtifactId(byte[] arg1);
    public A withNewArtifactId(char[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3);
    public A withNewArtifactId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewArtifactId(String arg1);
    public A addToExclusions(int index,CamelArtifactExclusion item);
    public A setToExclusions(int index,CamelArtifactExclusion item);
    public A addToExclusions(CamelArtifactExclusion... items);
    public A addAllToExclusions(Collection<CamelArtifactExclusion> items);
    public A removeFromExclusions(CamelArtifactExclusion... items);
    public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items);
    public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExclusions instead.
 * @return The buildable object.
 */
@Deprecated public List<CamelArtifactExclusion> getExclusions();
    public List<CamelArtifactExclusion> buildExclusions();
    public CamelArtifactExclusion buildExclusion(int index);
    public CamelArtifactExclusion buildFirstExclusion();
    public CamelArtifactExclusion buildLastExclusion();
    public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public A withExclusions(List<CamelArtifactExclusion> exclusions);
    public A withExclusions(CamelArtifactExclusion... exclusions);
    public Boolean hasExclusions();
    public A addNewExclusion(String artifactId,String groupId);
    public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusion();
    public CamelArtifactDependencyFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item);
    public CamelArtifactDependencyFluent.ExclusionsNested<A> setNewExclusionLike(int index,CamelArtifactExclusion item);
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editExclusion(int index);
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editFirstExclusion();
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editLastExclusion();
    public CamelArtifactDependencyFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
    public String getGroupId();
    public A withGroupId(String groupId);
    public Boolean hasGroupId();
    public A withNewGroupId(StringBuilder arg1);
    public A withNewGroupId(int[] arg1,int arg2,int arg3);
    public A withNewGroupId(char[] arg1);
    public A withNewGroupId(StringBuffer arg1);
    public A withNewGroupId(byte[] arg1,int arg2);
    public A withNewGroupId(byte[] arg1);
    public A withNewGroupId(char[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3);
    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGroupId(String arg1);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ExclusionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CamelArtifactExclusionFluent<CamelArtifactDependencyFluent.ExclusionsNested<N>> {

            public N and();
            public N endExclusion();    }


}
