package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CamelArtifactDependencyBuilder extends CamelArtifactDependencyFluentImpl<CamelArtifactDependencyBuilder> implements VisitableBuilder<CamelArtifactDependency,CamelArtifactDependencyBuilder> {

    CamelArtifactDependencyFluent<?> fluent;
    Boolean validationEnabled;

    public CamelArtifactDependencyBuilder() {
        this(true);
    }

    public CamelArtifactDependencyBuilder(Boolean validationEnabled) {
        this(new CamelArtifactDependency(), validationEnabled);
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent) {
        this(fluent, true);
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CamelArtifactDependency(), validationEnabled);
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,CamelArtifactDependency instance) {
        this(fluent, instance, true);
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependencyFluent<?> fluent,CamelArtifactDependency instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifactId(instance.getArtifactId()); 
        fluent.withExclusions(instance.getExclusions()); 
        fluent.withGroupId(instance.getGroupId()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependency instance) {
        this(instance,true);
    }

    public CamelArtifactDependencyBuilder(CamelArtifactDependency instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifactId(instance.getArtifactId()); 
        this.withExclusions(instance.getExclusions()); 
        this.withGroupId(instance.getGroupId()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableCamelArtifactDependency build() {
        EditableCamelArtifactDependency buildable = new EditableCamelArtifactDependency(fluent.getArtifactId(),fluent.getExclusions(),fluent.getGroupId(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CamelArtifactDependencyBuilder that = (CamelArtifactDependencyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
