package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class BuildStatusFluentImpl<A extends BuildStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildStatusFluent<A> {

    private List<ArtifactBuilder> artifacts;
    private String baseImage;
    private List<BuildConditionBuilder> conditions;
    private String digest;
    private String duration;
    private String error;
    private FailureBuilder failure;
    private String image;
    private String phase;
    private String platform;
    private String startedAt;

    public BuildStatusFluentImpl() {
    }

    public BuildStatusFluentImpl(BuildStatus instance) {
        this.withArtifacts(instance.getArtifacts()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConditions(instance.getConditions()); 
        this.withDigest(instance.getDigest()); 
        this.withDuration(instance.getDuration()); 
        this.withError(instance.getError()); 
        this.withFailure(instance.getFailure()); 
        this.withImage(instance.getImage()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withStartedAt(instance.getStartedAt()); 
    }

    public A addToArtifacts(int index,Artifact item) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToArtifacts(int index,Artifact item) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        ArtifactBuilder builder = new ArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToArtifacts(Artifact... items) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToArtifacts(Collection<Artifact> items) {
        if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromArtifacts(Artifact... items) {
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromArtifacts(Collection<Artifact> items) {
        for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<ArtifactBuilder> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          ArtifactBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildArtifacts instead.
 * @return The buildable object.
 */
@Deprecated public List<Artifact> getArtifacts() {
        return build(artifacts);
    }

    public List<Artifact> buildArtifacts() {
        return build(artifacts);
    }

    public Artifact buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    public Artifact buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    public Artifact buildLastArtifact() {
        return this.artifacts.get(artifacts.size() - 1).build();
    }

    public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArtifacts(List<Artifact> artifacts) {
        if (this.artifacts != null) { _visitables.get("artifacts").removeAll(this.artifacts);}
        if (artifacts != null) {this.artifacts = new ArrayList<ArtifactBuilder>(); for (Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
    }

    public A withArtifacts(Artifact... artifacts) {
        if (this.artifacts != null) {this.artifacts.clear();}
        if (artifacts != null) {for (Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
    }

    public Boolean hasArtifacts() {
        return artifacts != null && !artifacts.isEmpty();
    }

    public A addNewArtifact(String checksum,String id,String location,String target) {
        return (A)addToArtifacts(new Artifact(checksum, id, location, target));
    }

    public BuildStatusFluent.ArtifactsNested<A> addNewArtifact() {
        return new ArtifactsNestedImpl();
    }

    public BuildStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item) {
        return new ArtifactsNestedImpl(-1, item);
    }

    public BuildStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item) {
        return new ArtifactsNestedImpl(index, item);
    }

    public BuildStatusFluent.ArtifactsNested<A> editArtifact(int index) {
        if (artifacts.size() <= index) throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public BuildStatusFluent.ArtifactsNested<A> editFirstArtifact() {
        if (artifacts.size() == 0) throw new RuntimeException("Can't edit first artifacts. The list is empty.");
        return setNewArtifactLike(0, buildArtifact(0));
    }

    public BuildStatusFluent.ArtifactsNested<A> editLastArtifact() {
        int index = artifacts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last artifacts. The list is empty.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public BuildStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
        int index = -1;
        for (int i=0;i<artifacts.size();i++) { 
        if (predicate.test(artifacts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching artifacts. No match found.");
        return setNewArtifactLike(index, buildArtifact(index));
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A addToConditions(int index,BuildCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<BuildConditionBuilder>();}
        BuildConditionBuilder builder = new BuildConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,BuildCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<BuildConditionBuilder>();}
        BuildConditionBuilder builder = new BuildConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(BuildCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<BuildConditionBuilder>();}
        for (BuildCondition item : items) {BuildConditionBuilder builder = new BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<BuildCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<BuildConditionBuilder>();}
        for (BuildCondition item : items) {BuildConditionBuilder builder = new BuildConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(BuildCondition... items) {
        for (BuildCondition item : items) {BuildConditionBuilder builder = new BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<BuildCondition> items) {
        for (BuildCondition item : items) {BuildConditionBuilder builder = new BuildConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<BuildConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          BuildConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildCondition> getConditions() {
        return build(conditions);
    }

    public List<BuildCondition> buildConditions() {
        return build(conditions);
    }

    public BuildCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public BuildCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public BuildCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        for (BuildConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<BuildCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<BuildConditionBuilder>(); for (BuildCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(BuildCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (BuildCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public BuildStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,BuildCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public BuildStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public BuildStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public BuildStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getDigest() {
        return this.digest;
    }

    public A withDigest(String digest) {
        this.digest=digest; return (A) this;
    }

    public Boolean hasDigest() {
        return this.digest != null;
    }

    public A withNewDigest(StringBuilder arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(int[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(char[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(StringBuffer arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(byte[] arg1,int arg2) {
        return (A)withDigest(new String(arg1, arg2));
    }

    public A withNewDigest(byte[] arg1) {
        return (A)withDigest(new String(arg1));
    }

    public A withNewDigest(char[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3) {
        return (A)withDigest(new String(arg1, arg2, arg3));
    }

    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDigest(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDigest(String arg1) {
        return (A)withDigest(new String(arg1));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(int[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(char[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(byte[] arg1,int arg2) {
        return (A)withDuration(new String(arg1, arg2));
    }

    public A withNewDuration(byte[] arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(char[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3) {
        return (A)withDuration(new String(arg1, arg2, arg3));
    }

    public A withNewDuration(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDuration(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public String getError() {
        return this.error;
    }

    public A withError(String error) {
        this.error=error; return (A) this;
    }

    public Boolean hasError() {
        return this.error != null;
    }

    public A withNewError(StringBuilder arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(int[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(char[] arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuffer arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(byte[] arg1,int arg2) {
        return (A)withError(new String(arg1, arg2));
    }

    public A withNewError(byte[] arg1) {
        return (A)withError(new String(arg1));
    }

    public A withNewError(char[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(byte[] arg1,int arg2,int arg3) {
        return (A)withError(new String(arg1, arg2, arg3));
    }

    public A withNewError(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withError(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewError(String arg1) {
        return (A)withError(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public Failure buildFailure() {
        return this.failure!=null?this.failure.build():null;
    }

    public A withFailure(Failure failure) {
        _visitables.get("failure").remove(this.failure);
        if (failure!=null){ this.failure= new FailureBuilder(failure); _visitables.get("failure").add(this.failure);} return (A) this;
    }

    public Boolean hasFailure() {
        return this.failure != null;
    }

    public BuildStatusFluent.FailureNested<A> withNewFailure() {
        return new FailureNestedImpl();
    }

    public BuildStatusFluent.FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNestedImpl(item);
    }

    public BuildStatusFluent.FailureNested<A> editFailure() {
        return withNewFailureLike(getFailure());
    }

    public BuildStatusFluent.FailureNested<A> editOrNewFailure() {
        return withNewFailureLike(getFailure() != null ? getFailure(): new FailureBuilder().build());
    }

    public BuildStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item) {
        return withNewFailureLike(getFailure() != null ? getFailure(): item);
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform=platform; return (A) this;
    }

    public Boolean hasPlatform() {
        return this.platform != null;
    }

    public A withNewPlatform(StringBuilder arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(int[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(char[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(StringBuffer arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(byte[] arg1,int arg2) {
        return (A)withPlatform(new String(arg1, arg2));
    }

    public A withNewPlatform(byte[] arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public A withNewPlatform(char[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3) {
        return (A)withPlatform(new String(arg1, arg2, arg3));
    }

    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPlatform(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPlatform(String arg1) {
        return (A)withPlatform(new String(arg1));
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public A withStartedAt(String startedAt) {
        this.startedAt=startedAt; return (A) this;
    }

    public Boolean hasStartedAt() {
        return this.startedAt != null;
    }

    public A withNewStartedAt(StringBuilder arg1) {
        return (A)withStartedAt(new String(arg1));
    }

    public A withNewStartedAt(int[] arg1,int arg2,int arg3) {
        return (A)withStartedAt(new String(arg1, arg2, arg3));
    }

    public A withNewStartedAt(char[] arg1) {
        return (A)withStartedAt(new String(arg1));
    }

    public A withNewStartedAt(StringBuffer arg1) {
        return (A)withStartedAt(new String(arg1));
    }

    public A withNewStartedAt(byte[] arg1,int arg2) {
        return (A)withStartedAt(new String(arg1, arg2));
    }

    public A withNewStartedAt(byte[] arg1) {
        return (A)withStartedAt(new String(arg1));
    }

    public A withNewStartedAt(char[] arg1,int arg2,int arg3) {
        return (A)withStartedAt(new String(arg1, arg2, arg3));
    }

    public A withNewStartedAt(byte[] arg1,int arg2,int arg3) {
        return (A)withStartedAt(new String(arg1, arg2, arg3));
    }

    public A withNewStartedAt(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStartedAt(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStartedAt(String arg1) {
        return (A)withStartedAt(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildStatusFluentImpl that = (BuildStatusFluentImpl) o;
        if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (digest != null ? !digest.equals(that.digest) :that.digest != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (error != null ? !error.equals(that.error) :that.error != null) return false;
        if (failure != null ? !failure.equals(that.failure) :that.failure != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
        if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(artifacts,  baseImage,  conditions,  digest,  duration,  error,  failure,  image,  phase,  platform,  startedAt,  super.hashCode());
    }

    public class ArtifactsNestedImpl<N> extends ArtifactFluentImpl<BuildStatusFluent.ArtifactsNested<N>> implements BuildStatusFluent.ArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ArtifactBuilder builder;
        private final int index;

            ArtifactsNestedImpl(int index,Artifact item) {
                this.index = index;
                this.builder = new ArtifactBuilder(this, item);
                        
            }

            ArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new ArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endArtifact() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends BuildConditionFluentImpl<BuildStatusFluent.ConditionsNested<N>> implements BuildStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,BuildCondition item) {
                this.index = index;
                this.builder = new BuildConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new BuildConditionBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class FailureNestedImpl<N> extends FailureFluentImpl<BuildStatusFluent.FailureNested<N>> implements BuildStatusFluent.FailureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final FailureBuilder builder;

            FailureNestedImpl(Failure item) {
                this.builder = new FailureBuilder(this, item);
                        
            }

            FailureNestedImpl() {
                this.builder = new FailureBuilder(this);
                        
            }

            public N and() {
                return (N) BuildStatusFluentImpl.this.withFailure(builder.build());
            }

            public N endFailure() {
                return and();
            }
    }


}
