package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends Fluent<A> {


    public A addToArtifacts(int index,Artifact item);
    public A setToArtifacts(int index,Artifact item);
    public A addToArtifacts(Artifact... items);
    public A addAllToArtifacts(Collection<Artifact> items);
    public A removeFromArtifacts(Artifact... items);
    public A removeAllFromArtifacts(Collection<Artifact> items);
    public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildArtifacts instead.
 * @return The buildable object.
 */
@Deprecated public List<Artifact> getArtifacts();
    public List<Artifact> buildArtifacts();
    public Artifact buildArtifact(int index);
    public Artifact buildFirstArtifact();
    public Artifact buildLastArtifact();
    public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public A withArtifacts(List<Artifact> artifacts);
    public A withArtifacts(Artifact... artifacts);
    public Boolean hasArtifacts();
    public A addNewArtifact(String checksum,String id,String location,String target);
    public BuildStatusFluent.ArtifactsNested<A> addNewArtifact();
    public BuildStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item);
    public BuildStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item);
    public BuildStatusFluent.ArtifactsNested<A> editArtifact(int index);
    public BuildStatusFluent.ArtifactsNested<A> editFirstArtifact();
    public BuildStatusFluent.ArtifactsNested<A> editLastArtifact();
    public BuildStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate);
    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(int[] arg1,int arg2,int arg3);
    public A withNewBaseImage(char[] arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A withNewBaseImage(byte[] arg1,int arg2);
    public A withNewBaseImage(byte[] arg1);
    public A withNewBaseImage(char[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBaseImage(String arg1);
    public A addToConditions(int index,BuildCondition item);
    public A setToConditions(int index,BuildCondition item);
    public A addToConditions(BuildCondition... items);
    public A addAllToConditions(Collection<BuildCondition> items);
    public A removeFromConditions(BuildCondition... items);
    public A removeAllFromConditions(Collection<BuildCondition> items);
    public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<BuildCondition> getConditions();
    public List<BuildCondition> buildConditions();
    public BuildCondition buildCondition(int index);
    public BuildCondition buildFirstCondition();
    public BuildCondition buildLastCondition();
    public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    public A withConditions(List<BuildCondition> conditions);
    public A withConditions(BuildCondition... conditions);
    public Boolean hasConditions();
    public BuildStatusFluent.ConditionsNested<A> addNewCondition();
    public BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item);
    public BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,BuildCondition item);
    public BuildStatusFluent.ConditionsNested<A> editCondition(int index);
    public BuildStatusFluent.ConditionsNested<A> editFirstCondition();
    public BuildStatusFluent.ConditionsNested<A> editLastCondition();
    public BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate);
    public String getDigest();
    public A withDigest(String digest);
    public Boolean hasDigest();
    public A withNewDigest(StringBuilder arg1);
    public A withNewDigest(int[] arg1,int arg2,int arg3);
    public A withNewDigest(char[] arg1);
    public A withNewDigest(StringBuffer arg1);
    public A withNewDigest(byte[] arg1,int arg2);
    public A withNewDigest(byte[] arg1);
    public A withNewDigest(char[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3);
    public A withNewDigest(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDigest(String arg1);
    public String getDuration();
    public A withDuration(String duration);
    public Boolean hasDuration();
    public A withNewDuration(StringBuilder arg1);
    public A withNewDuration(int[] arg1,int arg2,int arg3);
    public A withNewDuration(char[] arg1);
    public A withNewDuration(StringBuffer arg1);
    public A withNewDuration(byte[] arg1,int arg2);
    public A withNewDuration(byte[] arg1);
    public A withNewDuration(char[] arg1,int arg2,int arg3);
    public A withNewDuration(byte[] arg1,int arg2,int arg3);
    public A withNewDuration(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDuration(String arg1);
    public String getError();
    public A withError(String error);
    public Boolean hasError();
    public A withNewError(StringBuilder arg1);
    public A withNewError(int[] arg1,int arg2,int arg3);
    public A withNewError(char[] arg1);
    public A withNewError(StringBuffer arg1);
    public A withNewError(byte[] arg1,int arg2);
    public A withNewError(byte[] arg1);
    public A withNewError(char[] arg1,int arg2,int arg3);
    public A withNewError(byte[] arg1,int arg2,int arg3);
    public A withNewError(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewError(String arg1);
    
/**
 * This method has been deprecated, please use method buildFailure instead.
 * @return The buildable object.
 */
@Deprecated public Failure getFailure();
    public Failure buildFailure();
    public A withFailure(Failure failure);
    public Boolean hasFailure();
    public BuildStatusFluent.FailureNested<A> withNewFailure();
    public BuildStatusFluent.FailureNested<A> withNewFailureLike(Failure item);
    public BuildStatusFluent.FailureNested<A> editFailure();
    public BuildStatusFluent.FailureNested<A> editOrNewFailure();
    public BuildStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(int[] arg1,int arg2,int arg3);
    public A withNewPhase(char[] arg1);
    public A withNewPhase(StringBuffer arg1);
    public A withNewPhase(byte[] arg1,int arg2);
    public A withNewPhase(byte[] arg1);
    public A withNewPhase(char[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3);
    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPhase(String arg1);
    public String getPlatform();
    public A withPlatform(String platform);
    public Boolean hasPlatform();
    public A withNewPlatform(StringBuilder arg1);
    public A withNewPlatform(int[] arg1,int arg2,int arg3);
    public A withNewPlatform(char[] arg1);
    public A withNewPlatform(StringBuffer arg1);
    public A withNewPlatform(byte[] arg1,int arg2);
    public A withNewPlatform(byte[] arg1);
    public A withNewPlatform(char[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3);
    public A withNewPlatform(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPlatform(String arg1);
    public String getStartedAt();
    public A withStartedAt(String startedAt);
    public Boolean hasStartedAt();
    public A withNewStartedAt(StringBuilder arg1);
    public A withNewStartedAt(int[] arg1,int arg2,int arg3);
    public A withNewStartedAt(char[] arg1);
    public A withNewStartedAt(StringBuffer arg1);
    public A withNewStartedAt(byte[] arg1,int arg2);
    public A withNewStartedAt(byte[] arg1);
    public A withNewStartedAt(char[] arg1,int arg2,int arg3);
    public A withNewStartedAt(byte[] arg1,int arg2,int arg3);
    public A withNewStartedAt(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewStartedAt(String arg1);
    public interface ArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ArtifactFluent<BuildStatusFluent.ArtifactsNested<N>> {

            public N and();
            public N endArtifact();    }


    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConditionFluent<BuildStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface FailureNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FailureFluent<BuildStatusFluent.FailureNested<N>> {

            public N and();
            public N endFailure();    }


}
