package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildStatusBuilder extends BuildStatusFluentImpl<BuildStatusBuilder> implements VisitableBuilder<BuildStatus,BuildStatusBuilder> {

    BuildStatusFluent<?> fluent;
    Boolean validationEnabled;

    public BuildStatusBuilder() {
        this(true);
    }

    public BuildStatusBuilder(Boolean validationEnabled) {
        this(new BuildStatus(), validationEnabled);
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BuildStatus(), validationEnabled);
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent,BuildStatus instance) {
        this(fluent, instance, true);
    }

    public BuildStatusBuilder(BuildStatusFluent<?> fluent,BuildStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withArtifacts(instance.getArtifacts()); 
        fluent.withBaseImage(instance.getBaseImage()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDigest(instance.getDigest()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withError(instance.getError()); 
        fluent.withFailure(instance.getFailure()); 
        fluent.withImage(instance.getImage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withPlatform(instance.getPlatform()); 
        fluent.withStartedAt(instance.getStartedAt()); 
        this.validationEnabled = validationEnabled; 
    }

    public BuildStatusBuilder(BuildStatus instance) {
        this(instance,true);
    }

    public BuildStatusBuilder(BuildStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withArtifacts(instance.getArtifacts()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConditions(instance.getConditions()); 
        this.withDigest(instance.getDigest()); 
        this.withDuration(instance.getDuration()); 
        this.withError(instance.getError()); 
        this.withFailure(instance.getFailure()); 
        this.withImage(instance.getImage()); 
        this.withPhase(instance.getPhase()); 
        this.withPlatform(instance.getPlatform()); 
        this.withStartedAt(instance.getStartedAt()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableBuildStatus build() {
        EditableBuildStatus buildable = new EditableBuildStatus(fluent.getArtifacts(),fluent.getBaseImage(),fluent.getConditions(),fluent.getDigest(),fluent.getDuration(),fluent.getError(),fluent.getFailure(),fluent.getImage(),fluent.getPhase(),fluent.getPlatform(),fluent.getStartedAt());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildStatusBuilder that = (BuildStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
