package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface BuildSpecFluent<A extends BuildSpecFluent<A>> extends Fluent<A> {


    public A addToTasks(int index,Task item);
    public A setToTasks(int index,Task item);
    public A addToTasks(Task... items);
    public A addAllToTasks(Collection<Task> items);
    public A removeFromTasks(Task... items);
    public A removeAllFromTasks(Collection<Task> items);
    public A removeMatchingFromTasks(Predicate<TaskBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTasks instead.
 * @return The buildable object.
 */
@Deprecated public List<Task> getTasks();
    public List<Task> buildTasks();
    public Task buildTask(int index);
    public Task buildFirstTask();
    public Task buildLastTask();
    public Task buildMatchingTask(Predicate<TaskBuilder> predicate);
    public Boolean hasMatchingTask(Predicate<TaskBuilder> predicate);
    public A withTasks(List<Task> tasks);
    public A withTasks(Task... tasks);
    public Boolean hasTasks();
    public BuildSpecFluent.TasksNested<A> addNewTask();
    public BuildSpecFluent.TasksNested<A> addNewTaskLike(Task item);
    public BuildSpecFluent.TasksNested<A> setNewTaskLike(int index,Task item);
    public BuildSpecFluent.TasksNested<A> editTask(int index);
    public BuildSpecFluent.TasksNested<A> editFirstTask();
    public BuildSpecFluent.TasksNested<A> editLastTask();
    public BuildSpecFluent.TasksNested<A> editMatchingTask(Predicate<TaskBuilder> predicate);
    public interface TasksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TaskFluent<BuildSpecFluent.TasksNested<N>> {

            public N and();
            public N endTask();    }


}
