/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.MavenSpec;
import io.fabric8.camelk.v1.MavenSpecFluent;
import io.fabric8.camelk.v1.MavenSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class MavenSpecBuilder
extends MavenSpecFluentImpl<MavenSpecBuilder>
implements VisitableBuilder<MavenSpec, MavenSpecBuilder> {
    MavenSpecFluent<?> fluent;
    Boolean validationEnabled;

    public MavenSpecBuilder() {
        this(false);
    }

    public MavenSpecBuilder(Boolean validationEnabled) {
        this(new MavenSpec(), validationEnabled);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MavenSpec(), validationEnabled);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent, MavenSpec instance) {
        this(fluent, instance, false);
    }

    public MavenSpecBuilder(MavenSpecFluent<?> fluent, MavenSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCaSecret(instance.getCaSecret());
        fluent.withExtension(instance.getExtension());
        fluent.withLocalRepository(instance.getLocalRepository());
        fluent.withProperties(instance.getProperties());
        fluent.withRepositories(instance.getRepositories());
        fluent.withSettings(instance.getSettings());
        fluent.withTimeout(instance.getTimeout());
        this.validationEnabled = validationEnabled;
    }

    public MavenSpecBuilder(MavenSpec instance) {
        this(instance, (Boolean)false);
    }

    public MavenSpecBuilder(MavenSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCaSecret(instance.getCaSecret());
        this.withExtension(instance.getExtension());
        this.withLocalRepository(instance.getLocalRepository());
        this.withProperties(instance.getProperties());
        this.withRepositories(instance.getRepositories());
        this.withSettings(instance.getSettings());
        this.withTimeout(instance.getTimeout());
        this.validationEnabled = validationEnabled;
    }

    public MavenSpec build() {
        MavenSpec buildable = new MavenSpec(this.fluent.getCaSecret(), this.fluent.getExtension(), this.fluent.getLocalRepository(), this.fluent.getProperties(), this.fluent.getRepositories(), this.fluent.getSettings(), this.fluent.getTimeout());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenSpecBuilder that = (MavenSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

