package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class CamelArtifactBuilder extends io.fabric8.camelk.v1.CamelArtifactFluentImpl<io.fabric8.camelk.v1.CamelArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.camelk.v1.CamelArtifact,io.fabric8.camelk.v1.CamelArtifactBuilder>{
  public CamelArtifactBuilder() {
    this(false);
  }
  public CamelArtifactBuilder(java.lang.Boolean validationEnabled) {
    this(new CamelArtifact(), validationEnabled);
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CamelArtifact(), validationEnabled);
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifactFluent<?> fluent,io.fabric8.camelk.v1.CamelArtifact instance) {
    this(fluent, instance, false);
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifactFluent<?> fluent,io.fabric8.camelk.v1.CamelArtifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArtifactId(instance.getArtifactId()); 
    fluent.withDataformats(instance.getDataformats()); 
    fluent.withDependencies(instance.getDependencies()); 
    fluent.withExclusions(instance.getExclusions()); 
    fluent.withGroupId(instance.getGroupId()); 
    fluent.withJavaTypes(instance.getJavaTypes()); 
    fluent.withLanguages(instance.getLanguages()); 
    fluent.withSchemes(instance.getSchemes()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifact instance) {
    this(instance,false);
  }
  public CamelArtifactBuilder(io.fabric8.camelk.v1.CamelArtifact instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withArtifactId(instance.getArtifactId()); 
    this.withDataformats(instance.getDataformats()); 
    this.withDependencies(instance.getDependencies()); 
    this.withExclusions(instance.getExclusions()); 
    this.withGroupId(instance.getGroupId()); 
    this.withJavaTypes(instance.getJavaTypes()); 
    this.withLanguages(instance.getLanguages()); 
    this.withSchemes(instance.getSchemes()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1.CamelArtifactFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1.CamelArtifact build() {
    CamelArtifact buildable = new CamelArtifact(fluent.getArtifactId(),fluent.getDataformats(),fluent.getDependencies(),fluent.getExclusions(),fluent.getGroupId(),fluent.getJavaTypes(),fluent.getLanguages(),fluent.getSchemes(),fluent.getVersion());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CamelArtifactBuilder that = (CamelArtifactBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}